/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.MapIMObjectGraph;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopierBuilder;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopierException;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopyHandler;
import org.openvpms.component.business.service.archetype.helper.IMObjectGraph;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class IMObjectCopier {
    private final ArchetypeService service;
    private final IMObjectCopyHandler handler;
    private Map<Reference, Copy> copies;

    public IMObjectCopier(IMObjectCopyHandler handler, ArchetypeService service) {
        this.handler = handler;
        this.service = service;
    }

    public List<org.openvpms.component.model.object.IMObject> apply(org.openvpms.component.model.object.IMObject object) {
        ArrayList<org.openvpms.component.model.object.IMObject> result = new ArrayList<org.openvpms.component.model.object.IMObject>();
        this.copies = new HashMap<Reference, Copy>();
        org.openvpms.component.model.object.IMObject target = this.apply(object, result, false);
        result.add(0, target);
        return result;
    }

    public IMObjectGraph copy(org.openvpms.component.model.object.IMObject object) {
        List<org.openvpms.component.model.object.IMObject> result = this.apply(object);
        org.openvpms.component.model.object.IMObject primary = result.get(0);
        return new MapIMObjectGraph(primary, result);
    }

    public static IMObjectCopierBuilder newCopier(ArchetypeService service) {
        return new IMObjectCopierBuilder(service);
    }

    protected org.openvpms.component.model.object.IMObject apply(org.openvpms.component.model.object.IMObject source, List<org.openvpms.component.model.object.IMObject> children, boolean save) {
        org.openvpms.component.model.object.IMObject target = this.handler.getObject(source, this.service);
        if (target != null) {
            Copy copy = new Copy(target);
            this.copies.put(source.getObjectReference(), copy);
            if (target != source) {
                this.doCopy(source, target, children, save);
            }
            copy.complete();
        }
        return target;
    }

    protected void doCopy(org.openvpms.component.model.object.IMObject source, org.openvpms.component.model.object.IMObject target, List<org.openvpms.component.model.object.IMObject> children, boolean save) {
        ArchetypeDescriptor sourceType = DescriptorHelper.getArchetypeDescriptor(source, this.service);
        ArchetypeDescriptor targetType = DescriptorHelper.getArchetypeDescriptor(target, this.service);
        for (NodeDescriptor sourceDesc : sourceType.getAllNodeDescriptors()) {
            NodeDescriptor targetDesc = this.handler.getNode(sourceType, sourceDesc, targetType);
            if (targetDesc == null) continue;
            if (sourceDesc.isObjectReference()) {
                Reference ref = (Reference)sourceDesc.getValue(source);
                if (ref == null) continue;
                ref = this.copyReference(ref, source, children, save);
                sourceDesc.setValue(target, ref);
                continue;
            }
            if (!sourceDesc.isCollection()) {
                targetDesc.setValue(target, sourceDesc.getValue(source));
                continue;
            }
            this.copyChildren(source, target, children, save, sourceDesc, targetDesc);
        }
        this.service.deriveValues(target);
    }

    protected void missingReference(Reference reference, org.openvpms.component.model.object.IMObject parent) {
        throw new IMObjectCopierException(IMObjectCopierException.ErrorCode.ObjectNotFound, reference, parent.getObjectReference());
    }

    private void copyChildren(org.openvpms.component.model.object.IMObject source, org.openvpms.component.model.object.IMObject target, List<org.openvpms.component.model.object.IMObject> children, boolean save, NodeDescriptor sourceDesc, NodeDescriptor targetDesc) {
        for (org.openvpms.component.model.object.IMObject iMObject : sourceDesc.getChildren(source)) {
            Copy copy = null;
            org.openvpms.component.model.object.IMObject value = sourceDesc.isParentChild() ? ((copy = this.copies.get(iMObject.getObjectReference())) == null ? this.apply(iMObject, children, save) : copy.getObject()) : iMObject;
            if (value == null) continue;
            if (copy == null || copy.isComplete()) {
                targetDesc.addChildToCollection((IMObject)target, value);
                continue;
            }
            copy.queue(target, targetDesc);
        }
    }

    private Reference copyReference(Reference reference, org.openvpms.component.model.object.IMObject parent, List<org.openvpms.component.model.object.IMObject> children, boolean save) {
        Copy copy = this.copies.get(reference);
        org.openvpms.component.model.object.IMObject object = null;
        if (copy != null) {
            object = copy.getObject();
        } else {
            org.openvpms.component.model.object.IMObject original = this.service.get(reference);
            if (original == null) {
                this.missingReference(reference, parent);
            } else {
                object = this.apply(original, children, save);
                if (object != original && object != null) {
                    children.add(object);
                    if (save) {
                        this.service.save(object);
                    }
                }
            }
        }
        return object != null ? object.getObjectReference() : null;
    }

    private static class CollectionAdder {
        private final org.openvpms.component.model.object.IMObject parent;
        private final NodeDescriptor descriptor;
        private final org.openvpms.component.model.object.IMObject value;

        CollectionAdder(org.openvpms.component.model.object.IMObject parent, NodeDescriptor descriptor, org.openvpms.component.model.object.IMObject value) {
            this.parent = parent;
            this.descriptor = descriptor;
            this.value = value;
        }

        public void add() {
            this.descriptor.addChildToCollection((IMObject)this.parent, this.value);
        }
    }

    private static class Copy {
        private final org.openvpms.component.model.object.IMObject object;
        private boolean complete;
        private List<CollectionAdder> queue;

        Copy(org.openvpms.component.model.object.IMObject object) {
            this.object = object;
        }

        public org.openvpms.component.model.object.IMObject getObject() {
            return this.object;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public void complete() {
            this.complete = true;
            if (this.queue != null) {
                for (CollectionAdder adder : this.queue) {
                    adder.add();
                }
                this.queue.clear();
            }
        }

        public void queue(org.openvpms.component.model.object.IMObject target, NodeDescriptor descriptor) {
            if (this.queue == null) {
                this.queue = new ArrayList<CollectionAdder>();
            }
            this.queue.add(new CollectionAdder(target, descriptor, this.object));
        }
    }
}

