/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import java.util.Set;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.IMObjectBeanException;
import org.openvpms.component.system.common.util.AbstractPropertySet;

public abstract class AbstractNodePropertySet
extends AbstractPropertySet {
    private final IMObject object;
    private ArchetypeDescriptor archetype;

    protected AbstractNodePropertySet(IMObject object) {
        this.object = object;
    }

    public IMObject getObject() {
        return this.object;
    }

    @Override
    public Set<String> getNames() {
        return this.getArchetype().getNodeDescriptorMap().keySet();
    }

    @Override
    public Object get(String name) {
        NodeDescriptor node = this.getNode(name);
        return node.getValue(this.object);
    }

    @Override
    public void set(String name, Object value) {
        NodeDescriptor node = this.getNode(name);
        node.setValue(this.object, value);
    }

    public ArchetypeDescriptor getArchetype() {
        if (this.archetype == null) {
            String type = this.object.getArchetype();
            this.archetype = this.getArchetypeService().getArchetypeDescriptor(type);
            if (this.archetype == null) {
                throw new IMObjectBeanException(IMObjectBeanException.ErrorCode.ArchetypeNotFound, type);
            }
        }
        return this.archetype;
    }

    public NodeDescriptor getNode(String name) {
        NodeDescriptor node = this.getArchetype().getNodeDescriptor(name);
        if (node == null) {
            String shortName = this.object.getArchetype();
            throw new IMObjectBeanException(IMObjectBeanException.ErrorCode.NodeDescriptorNotFound, name, shortName);
        }
        return node;
    }

    protected abstract IArchetypeService getArchetypeService();
}

