/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openvpms.component.business.service.archetype.handler.AbstractArchetypeHandlers;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.handler.PropertiesReader;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortNamePairArchetypeHandlers<T>
extends AbstractArchetypeHandlers<T> {
    private final Class<T> type;
    private final Map<String, Handlers<T>> handlers = new HashMap<String, Handlers<T>>();
    private static final Logger log = LoggerFactory.getLogger(ShortNamePairArchetypeHandlers.class);

    public ShortNamePairArchetypeHandlers(String name, Class<T> type, ArchetypeService service) {
        super(service);
        this.type = type;
        this.load(name);
    }

    public void load(String name) {
        Reader parser = new Reader();
        parser.read(name);
    }

    @Override
    public ArchetypeHandler<T> getHandler(String shortName) {
        return this.getHandler(shortName, null);
    }

    public ArchetypeHandler<T> getHandler(String primary, String secondary) {
        ArchetypeHandler<T> handler = null;
        String match = this.getShortName(primary, this.handlers.keySet());
        if (match != null) {
            Handlers<T> handlers = this.handlers.get(match);
            if (secondary != null && (match = this.getShortName(secondary, handlers.getShortNames())) != null) {
                handler = handlers.get(match);
            }
            if (handler == null) {
                handler = handlers.getHandler();
            }
        }
        return handler;
    }

    private static class Handlers<T> {
        private final Map<String, ArchetypeHandler<T>> handlers = new HashMap<String, ArchetypeHandler<T>>();
        private ArchetypeHandler<T> handler;

        private Handlers() {
        }

        public void setHandler(ArchetypeHandler<T> handler) {
            this.handler = handler;
        }

        public ArchetypeHandler<T> getHandler() {
            return this.handler;
        }

        public void add(String shortName, ArchetypeHandler<T> handler) {
            this.handlers.put(shortName, handler);
        }

        public ArchetypeHandler<T> get(String shortName) {
            return this.handlers.get(shortName);
        }

        public Set<String> getShortNames() {
            return this.handlers.keySet();
        }
    }

    private class Reader
    extends PropertiesReader {
        private Reader() {
        }

        @Override
        protected void parse(String key, String value, String path) {
            Class<?> clazz = this.getClass(value, ShortNamePairArchetypeHandlers.this.type, path);
            if (clazz != null) {
                String[] pair = key.split(",");
                if (pair.length == 0 || pair.length > 2) {
                    log.error("Invalid short name pair={}, loaded from path={}", (Object)key, (Object)path);
                } else if (pair.length == 1) {
                    this.addHandler(pair[0], clazz, path);
                } else {
                    this.addHandler(pair[0], pair[1], clazz, path);
                }
            }
        }

        private void addHandler(String shortName, Class<T> type, String path) {
            String[] matches = this.getShortNames(shortName, path);
            if (matches.length != 0) {
                Handlers handlers = this.getHandlers(shortName);
                if (handlers.getHandler() != null) {
                    log.warn("Duplicate short name={} from {}: ignoring", (Object)shortName, (Object)path);
                } else {
                    ArchetypeHandler handler = new ArchetypeHandler(shortName, type);
                    handlers.setHandler(handler);
                }
            } else {
                log.warn("Invalid archetype for handler={}, short name={} from {}: ignoring", new Object[]{type, shortName, path});
            }
        }

        private void addHandler(String primary, String secondary, Class<T> type, String path) {
            String[] primaryMatches = this.getShortNames(primary, path);
            String[] secondaryMatches = this.getShortNames(secondary, path);
            if (primaryMatches.length != 0 && secondaryMatches.length != 0) {
                Handlers handlers = this.getHandlers(primary);
                if (handlers.get(secondary) != null) {
                    log.warn("Duplicate short name={} for primary short name={} from {}: ignoring", new Object[]{secondary, primary, path});
                } else {
                    ArchetypeHandler handler = new ArchetypeHandler(secondary, type);
                    handlers.add(secondary, handler);
                }
            }
        }

        private String[] getShortNames(String shortName, String path) {
            String[] matches = ShortNamePairArchetypeHandlers.this.getShortNames(shortName, false);
            if (matches.length == 0) {
                log.warn("No archetypes found matching short name={}, loaded from path={}", (Object)shortName, (Object)path);
            }
            return matches;
        }

        private Handlers<T> getHandlers(String shortName) {
            return ShortNamePairArchetypeHandlers.this.handlers.computeIfAbsent(shortName, s -> new Handlers());
        }
    }
}

