/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.assertion;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.assertion.LocaleProperCaseRules;
import org.openvpms.component.business.service.archetype.assertion.ProperCaseConverter;
import org.openvpms.component.business.service.archetype.assertion.ProperCaseRules;

public class ProperCaseNameConverter
implements ProperCaseConverter {
    private final ProperCaseRules rules;
    private String[][] space;
    private String[][] spaceBefore;
    private String[][] spaceAfter;
    private String[][] exceptions;
    private String[][] startsWith;
    private String[][] contains;
    private String[][] endsWith;
    private int version = -1;

    public ProperCaseNameConverter() {
        this(new LocaleProperCaseRules());
    }

    public ProperCaseNameConverter(ProperCaseRules rules) {
        this.rules = rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String convert(String text) {
        Converter converter;
        if (text == null) {
            return "";
        }
        ProperCaseNameConverter properCaseNameConverter = this;
        synchronized (properCaseNameConverter) {
            this.getRules();
            converter = new Converter(text, this.space, this.spaceBefore, this.spaceAfter, this.exceptions, this.startsWith, this.endsWith, this.contains);
        }
        return converter.convert();
    }

    private synchronized void getRules() {
        if (this.exceptions == null || this.version != this.rules.getVersion()) {
            this.space = this.getStrings(this.rules.getSpace());
            this.spaceBefore = this.getStrings(this.rules.getSpaceBefore());
            this.spaceAfter = this.getStrings(this.rules.getSpaceAfter());
            this.exceptions = this.getStrings(this.rules.getExceptions());
            this.startsWith = this.getStrings(this.rules.getStartsWith());
            this.endsWith = this.getStrings(this.rules.getEndsWith());
            this.contains = this.getStrings(this.rules.getContains());
            this.version = this.rules.getVersion();
        }
    }

    private String[][] getStrings(String[] propercase) {
        String[][] result = new String[propercase.length][];
        Arrays.sort(propercase, (o1, o2) -> -(o1.length() - o2.length()));
        for (int i = 0; i < result.length; ++i) {
            result[i] = new String[2];
            result[i][0] = propercase[i].toLowerCase();
            result[i][1] = propercase[i];
        }
        return result;
    }

    private static class Converter {
        private final String text;
        private final StringBuilder result;
        private int start;
        private final int length;
        private final String[][] exceptions;
        private final String[][] startsWith;
        private final String[][] endsWith;
        private final String[][] contains;

        public Converter(String text, String[][] space, String[][] spaceBefore, String[][] spaceAfter, String[][] exceptions, String[][] startsWith, String[][] endsWith, String[][] contains) {
            text = text.toLowerCase();
            for (String[] rule : space) {
                text = text.replace(rule[0], " " + rule[1] + " ");
            }
            for (String[] rule : spaceBefore) {
                text = text.replace(rule[0], " " + rule[1]);
            }
            for (String[] rule : spaceAfter) {
                text = text.replace(rule[0], rule[1] + " ");
            }
            text = StringUtils.strip((String)text);
            this.text = text = text.replaceAll(" +", " ");
            this.length = text.length();
            this.result = new StringBuilder(text.length());
            this.exceptions = exceptions;
            this.startsWith = startsWith;
            this.endsWith = endsWith;
            this.contains = contains;
        }

        public String convert() {
            this.start = 0;
            while (this.start < this.length) {
                int matchLen = this.addExceptionMatch();
                boolean capNext = false;
                if (matchLen == 0) {
                    capNext = true;
                    matchLen = this.addMatch(this.startsWith, this.length);
                }
                this.start += matchLen;
                int end = this.nextWhitespace();
                String endMatch = this.getEndsWith(end);
                if (endMatch != null) {
                    end -= endMatch.length();
                }
                while (this.start < end && !Character.isWhitespace(this.text.charAt(this.start))) {
                    matchLen = this.addMatch(this.contains, end);
                    if (matchLen == 0) {
                        if (capNext) {
                            this.result.append(Character.toTitleCase(this.text.charAt(this.start)));
                            capNext = false;
                        } else {
                            this.result.append(this.text.charAt(this.start));
                        }
                        ++this.start;
                        continue;
                    }
                    this.start += matchLen;
                    capNext = true;
                }
                if (endMatch != null) {
                    this.result.append(endMatch);
                    this.start += endMatch.length();
                }
                while (this.start < this.length && Character.isWhitespace(this.text.charAt(this.start))) {
                    this.result.append(this.text.charAt(this.start));
                    ++this.start;
                }
            }
            return this.result.toString();
        }

        private int addExceptionMatch() {
            String[] pair;
            int end;
            int matchLen = 0;
            String[][] stringArray = this.exceptions;
            int n = stringArray.length;
            for (int i = 0; !(i >= n || ((end = this.start + (pair = stringArray[i])[0].length()) == this.length || end < this.length && Character.isWhitespace(this.text.charAt(end))) && (matchLen = this.addMatch(pair)) != 0); ++i) {
            }
            return matchLen;
        }

        private int addMatch(String[][] pairs, int end) {
            int matchLen = 0;
            for (String[] pair : pairs) {
                if (this.start + pair[0].length() <= end && (matchLen = this.addMatch(pair)) != 0) break;
            }
            return matchLen;
        }

        private int addMatch(String[] pair) {
            if (this.text.startsWith(pair[0], this.start)) {
                String proper = pair[1];
                this.result.append(proper);
                return proper.length();
            }
            return 0;
        }

        private String getEndsWith(int end) {
            for (String[] pair : this.endsWith) {
                String lower = pair[0];
                if (!this.text.startsWith(lower, end - lower.length())) continue;
                return pair[1];
            }
            return null;
        }

        private int nextWhitespace() {
            for (int i = this.start + 1; i < this.length; ++i) {
                if (!Character.isWhitespace(this.text.charAt(i))) continue;
                return i;
            }
            return this.length;
        }
    }
}

