/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.security;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openvpms.component.business.domain.im.party.Party;
import org.openvpms.component.business.domain.im.security.SecurityRole;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class User
extends Party
implements org.openvpms.component.model.user.User,
UserDetails {
    private String userName;
    private String password;
    private boolean changePassword;
    private Set<SecurityRole> roles = new HashSet<SecurityRole>();
    private static final long serialVersionUID = 3L;

    public User() {
    }

    public User(String username, String password, boolean active) {
        this.userName = username;
        this.password = password;
        this.setName(username);
        this.setActive(active);
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public Collection<GrantedAuthority> getAuthorities() {
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        for (SecurityRole role : this.roles) {
            authorities.addAll(role.getAuthorities());
        }
        return authorities;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return this.isActive();
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.userName;
    }

    public void setUsername(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setChangePassword(boolean changePassword) {
        this.changePassword = changePassword;
    }

    public boolean getChangePassword() {
        return this.changePassword;
    }

    public Set<SecurityRole> getRoles() {
        return this.roles;
    }

    public void addRole(SecurityRole role) {
        this.roles.add(role);
    }

    public void removeRole(SecurityRole role) {
        this.roles.remove(role);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        User copy = (User)super.clone();
        copy.roles = new HashSet<SecurityRole>(this.roles);
        return copy;
    }

    protected void setRoles(Set<SecurityRole> roles) {
        this.roles = roles;
    }
}

