/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.archetype.descriptor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openvpms.component.business.domain.im.datatypes.property.AssertionProperty;
import org.openvpms.component.business.domain.im.datatypes.property.PropertyList;
import org.openvpms.component.model.archetype.ArchetypeRange;
import org.openvpms.component.model.archetype.AssertionDescriptor;
import org.openvpms.component.model.archetype.NamedProperty;
import org.openvpms.component.model.archetype.PropertyMap;

class ArchetypeRangeAssertion
implements ArchetypeRange {
    private final AssertionDescriptor descriptor;

    public ArchetypeRangeAssertion(AssertionDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public List<String> getArchetypes() {
        ArrayList<String> result = new ArrayList<String>();
        PropertyList archetypes = (PropertyList)this.descriptor.getProperty("archetypes");
        for (NamedProperty property : archetypes.getProperties()) {
            Map properties = ((PropertyMap)property).getProperties();
            AssertionProperty shortName = (AssertionProperty)properties.get("shortName");
            result.add(shortName.getValue());
        }
        return result;
    }

    public String getDefaultArchetype() {
        NamedProperty property = this.descriptor.getProperty("default");
        return property instanceof AssertionProperty ? ((AssertionProperty)property).getValue() : null;
    }
}

