/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.product;

import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.common.DOState;
import org.openvpms.component.business.dao.hibernate.im.common.SetAssembler;
import org.openvpms.component.business.dao.hibernate.im.entity.EntityAssembler;
import org.openvpms.component.business.dao.hibernate.im.product.ProductDO;
import org.openvpms.component.business.dao.hibernate.im.product.ProductDOImpl;
import org.openvpms.component.business.dao.hibernate.im.product.ProductPriceDO;
import org.openvpms.component.business.domain.im.product.Product;
import org.openvpms.component.business.domain.im.product.ProductPrice;

public class ProductAssembler
extends EntityAssembler<Product, ProductDO> {
    private static final SetAssembler<ProductPrice, ProductPriceDO> PRICES = SetAssembler.create(ProductPrice.class, ProductPriceDO.class);

    public ProductAssembler() {
        super(org.openvpms.component.model.product.Product.class, Product.class, ProductDO.class, ProductDOImpl.class);
    }

    @Override
    protected void assembleDO(ProductDO target, Product source, DOState state, Context context) {
        super.assembleDO(target, source, state, context);
        PRICES.assembleDO(target.getProductPrices(), source.getProductPrices(), state, context);
    }

    @Override
    protected void assembleObject(Product target, ProductDO source, Context context) {
        super.assembleObject(target, source, context);
        PRICES.assembleObject(target.getProductPrices(), source.getProductPrices(), context);
    }

    @Override
    protected Product create(ProductDO object) {
        return new Product();
    }

    @Override
    protected ProductDO create(Product object) {
        return new ProductDOImpl();
    }
}

