/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.lookup;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.archetype.AssertionDescriptor;
import org.openvpms.component.model.archetype.NamedProperty;

class LookupUsageFinder {
    private final IArchetypeDescriptorCache archetypes;

    public LookupUsageFinder(IArchetypeDescriptorCache archetypes) {
        this.archetypes = archetypes;
    }

    public Map<NodeDescriptor, ArchetypeDescriptor> getCodeReferences(String shortName) {
        HashMap<NodeDescriptor, ArchetypeDescriptor> result = new HashMap<NodeDescriptor, ArchetypeDescriptor>();
        ArchetypeId id = new ArchetypeId(shortName);
        for (ArchetypeDescriptor archetype : this.archetypes.getArchetypeDescriptors()) {
            if (TypeHelper.isA(archetype.getType(), shortName)) continue;
            this.collectCodeReferences(id, archetype, result);
        }
        return result;
    }

    private void collectCodeReferences(ArchetypeId id, ArchetypeDescriptor archetype, Map<NodeDescriptor, ArchetypeDescriptor> result) {
        for (NodeDescriptor descriptor : archetype.getAllNodeDescriptors()) {
            AssertionDescriptor assertion = descriptor.getAssertionDescriptor("lookup");
            if (assertion == null) continue;
            String type = LookupUsageFinder.getValue(assertion, "type");
            if ("lookup".equals(type)) {
                if (!this.referencesLookup(assertion, id)) continue;
                result.put(descriptor, archetype);
                continue;
            }
            if (!"targetLookup".equals(type) || !this.referencesTargetLookup(assertion, id)) continue;
            result.put(descriptor, archetype);
        }
    }

    private boolean referencesLookup(AssertionDescriptor assertion, ArchetypeId lookup) {
        String shortName = LookupUsageFinder.getValue(assertion, "source");
        return shortName != null && TypeHelper.isA(lookup, shortName);
    }

    private boolean referencesTargetLookup(AssertionDescriptor assertion, ArchetypeId lookup) {
        String relationship = LookupUsageFinder.getValue(assertion, "relationship");
        for (ArchetypeDescriptor archetype : this.archetypes.getArchetypeDescriptors(relationship)) {
            NodeDescriptor node = archetype.getNodeDescriptor("target");
            if (node == null || !this.references(node, lookup)) continue;
            return true;
        }
        return false;
    }

    private boolean references(NodeDescriptor descriptor, ArchetypeId lookup) {
        String[] shortNames = this.getShortNames(descriptor.getArchetypeRange());
        if (shortNames.length == 0 && !StringUtils.isEmpty((CharSequence)descriptor.getFilter())) {
            shortNames = this.getShortNames(new String[]{descriptor.getFilter()});
        }
        return TypeHelper.isA(lookup, shortNames);
    }

    private String[] getShortNames(String[] shortNames) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String shortName : shortNames) {
            List<String> matches = this.archetypes.getArchetypeShortNames(shortName, false);
            result.addAll(matches);
        }
        return result.toArray(new String[0]);
    }

    private static String getValue(AssertionDescriptor assertion, String name) {
        NamedProperty property = assertion.getProperty(name);
        return property != null ? (String)property.getValue() : null;
    }
}

