/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.audit;

import java.io.Serializable;
import java.util.List;
import org.openvpms.component.business.dao.im.audit.AuditDAOException;
import org.openvpms.component.business.dao.im.audit.IAuditDAO;
import org.openvpms.component.business.domain.im.audit.AuditRecord;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class AuditDAOHibernate
extends HibernateDaoSupport
implements IAuditDAO {
    private static final String AUDIT_QUERY = "from  " + AuditRecord.class.getName() + " as auditRecord where auditRecord.archetypeId = ? and auditRecord.objectId = ?";

    @Override
    public List<AuditRecord> getByObjectId(String archetypeId, long objectId) {
        List results;
        try {
            results = this.getHibernateTemplate().find(AUDIT_QUERY, new Object[]{archetypeId, objectId});
        }
        catch (Exception exception) {
            throw new AuditDAOException(AuditDAOException.ErrorCode.FailedToFindAuditRecords, new Object[]{archetypeId, objectId}, exception);
        }
        return results;
    }

    @Override
    public AuditRecord getById(long id) {
        try {
            return (AuditRecord)this.getHibernateTemplate().load(AuditRecord.class, (Serializable)Long.valueOf(id));
        }
        catch (Exception exception) {
            throw new AuditDAOException(AuditDAOException.ErrorCode.FailedToFindAuditRecordById, new Object[]{id});
        }
    }

    @Override
    public void insert(AuditRecord audit) {
        try {
            this.getHibernateTemplate().save((Object)audit);
        }
        catch (Exception exception) {
            throw new AuditDAOException(AuditDAOException.ErrorCode.FailedToInsertAuditRecord, new Object[]{audit.getArchetypeId(), audit.getObjectId()}, exception);
        }
    }
}

