/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.archetype;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.openvpms.component.business.dao.hibernate.im.archetype.ArchetypeDescriptorDO;
import org.openvpms.component.business.dao.hibernate.im.archetype.NodeDescriptorDO;
import org.openvpms.component.business.dao.hibernate.im.common.AuditableIMObjectDOImpl;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.archetype.descriptor.DescriptorException;

public class ArchetypeDescriptorDOImpl
extends AuditableIMObjectDOImpl
implements ArchetypeDescriptorDO {
    private ArchetypeId type;
    private String displayName;
    private String className;
    private boolean latest;
    private boolean primary = true;
    private boolean singleton;
    private Map<String, NodeDescriptorDO> nodeDescriptors = new LinkedHashMap<String, NodeDescriptorDO>();

    public ArchetypeDescriptorDOImpl() {
        this.setArchetypeId(new ArchetypeId("descriptor.archetype.1.0"));
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.type = StringUtils.isEmpty((CharSequence)name) ? null : new ArchetypeId(name);
    }

    @Override
    public ArchetypeId getType() {
        return this.type;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public boolean isLatest() {
        return this.latest;
    }

    @Override
    public void setLatest(boolean latest) {
        this.latest = latest;
    }

    @Override
    public boolean isPrimary() {
        return this.primary;
    }

    @Override
    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    @Override
    public boolean isSingleton() {
        return this.singleton;
    }

    @Override
    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    @Override
    public void addNodeDescriptor(NodeDescriptorDO node) {
        if (this.nodeDescriptors.containsKey(node.getName())) {
            throw new DescriptorException(DescriptorException.ErrorCode.DuplicateNodeDescriptor, node.getName(), this.getName());
        }
        this.nodeDescriptors.put(node.getName(), node);
        node.setArchetypeDescriptor(this);
    }

    @Override
    public void removeNodeDescriptor(NodeDescriptorDO node) {
        NodeDescriptorDO removed = this.nodeDescriptors.remove(node.getName());
        if (removed != null) {
            removed.setArchetypeDescriptor(null);
        }
    }

    @Override
    public Map<String, NodeDescriptorDO> getNodeDescriptors() {
        return this.nodeDescriptors;
    }

    @Override
    public Map<String, NodeDescriptorDO> getAllNodeDescriptors() {
        LinkedHashMap<String, NodeDescriptorDO> result = new LinkedHashMap<String, NodeDescriptorDO>();
        for (NodeDescriptorDO descriptor : this.nodeDescriptors.values()) {
            result.put(descriptor.getName(), descriptor);
            result.putAll(descriptor.getNodeDescriptors());
        }
        return result;
    }

    @Override
    public NodeDescriptorDO getNodeDescriptor(String name) {
        return this.getAllNodeDescriptors().get(name);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public int hashCode() {
        return this.type != null ? this.type.hashCode() : super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ArchetypeDescriptorDO)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ArchetypeDescriptorDO desc = (ArchetypeDescriptorDO)obj;
        return this.type.equals(desc.getType());
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.getName()).append("type", (Object)this.type).append("displayName", (Object)this.displayName).append("className", (Object)this.className).append("isLatest", this.latest).append("primary", this.primary).append("singleton", this.singleton).append("nodeDescriptors", this.nodeDescriptors).toString();
    }

    protected void setType(ArchetypeId type) {
        this.type = type;
    }

    protected void setNodeDescriptors(Map<String, NodeDescriptorDO> descriptors) {
        this.nodeDescriptors = descriptors;
    }
}

