/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.act;

import java.math.BigDecimal;
import org.openvpms.component.business.dao.hibernate.im.act.AbstractActAssembler;
import org.openvpms.component.business.dao.hibernate.im.act.FinancialActDO;
import org.openvpms.component.business.dao.hibernate.im.act.FinancialActDOImpl;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.common.DOState;
import org.openvpms.component.business.domain.im.act.FinancialAct;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;

public class FinancialActAssembler
extends AbstractActAssembler<FinancialAct, FinancialActDO> {
    public FinancialActAssembler() {
        super(org.openvpms.component.model.act.FinancialAct.class, FinancialAct.class, FinancialActDO.class, FinancialActDOImpl.class);
    }

    @Override
    protected void assembleDO(FinancialActDO target, FinancialAct source, DOState state, Context context) {
        super.assembleDO(target, source, state, context);
        target.setAllocatedAmount(this.toMoney(source.getAllocatedAmount()));
        target.setCredit(source.isCredit());
        target.setFixedAmount(this.toMoney(source.getFixedAmount()));
        target.setUnitAmount(this.toMoney(source.getUnitAmount()));
        target.setFixedCost(this.toMoney(source.getFixedCost()));
        target.setUnitCost(this.toMoney(source.getUnitCost()));
        target.setPrinted(source.isPrinted());
        target.setQuantity(source.getQuantity());
        target.setTaxAmount(this.toMoney(source.getTaxAmount()));
        target.setTotal(this.toMoney(source.getTotal()));
    }

    @Override
    protected void assembleObject(FinancialAct target, FinancialActDO source, Context context) {
        super.assembleObject(target, source, context);
        target.setAllocatedAmount(source.getAllocatedAmount());
        target.setCredit(source.isCredit());
        target.setFixedAmount(source.getFixedAmount());
        target.setUnitAmount(source.getUnitAmount());
        target.setFixedCost(source.getFixedCost());
        target.setUnitCost(source.getUnitCost());
        target.setPrinted(source.isPrinted());
        target.setQuantity(source.getQuantity());
        target.setTaxAmount(source.getTaxAmount());
        target.setTotal(source.getTotal());
    }

    @Override
    protected FinancialAct create(FinancialActDO object) {
        return new FinancialAct();
    }

    @Override
    protected FinancialActDO create(FinancialAct object) {
        return new FinancialActDOImpl();
    }

    private Money toMoney(BigDecimal value) {
        Money result = null;
        if (value instanceof Money) {
            result = (Money)value;
        }
        if (value != null) {
            result = new Money(value);
        }
        return result;
    }
}

