/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im;

import org.openvpms.component.business.dao.hibernate.im.act.ActDeleteHandler;
import org.openvpms.component.business.dao.hibernate.im.common.CompoundAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.DefaultDeleteHandler;
import org.openvpms.component.business.dao.hibernate.im.common.DeleteHandler;
import org.openvpms.component.business.dao.hibernate.im.entity.EntityDeleteHandler;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupDeleteHandler;
import org.openvpms.component.business.domain.im.act.Act;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.common.Entity;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.lookup.Lookup;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;
import org.openvpms.component.model.object.Reference;

public class DeleteHandlerFactory {
    private final IArchetypeDescriptorCache archetypes;
    private final DeleteHandler act;
    private final DeleteHandler entity;
    private final DeleteHandler lookup;
    private final DeleteHandler defaultHandler;

    public DeleteHandlerFactory(CompoundAssembler assembler, IArchetypeDescriptorCache archetypes) {
        this.archetypes = archetypes;
        this.act = new ActDeleteHandler(assembler);
        this.entity = new EntityDeleteHandler(assembler);
        this.lookup = new LookupDeleteHandler(assembler, archetypes);
        this.defaultHandler = new DefaultDeleteHandler(assembler);
    }

    public DeleteHandler getHandler(IMObject object) {
        if (object instanceof Act) {
            return this.act;
        }
        if (object instanceof Entity) {
            return this.entity;
        }
        if (object instanceof Lookup) {
            return this.lookup;
        }
        return this.defaultHandler;
    }

    public DeleteHandler getHandler(Reference reference) {
        ArchetypeDescriptor descriptor = this.archetypes.getArchetypeDescriptor(reference.getArchetype());
        if (descriptor == null) {
            throw new IllegalStateException("No descriptor for archetypes of type=" + reference.getArchetype());
        }
        if (org.openvpms.component.model.act.Act.class.isAssignableFrom(descriptor.getClassType())) {
            return this.act;
        }
        if (org.openvpms.component.model.entity.Entity.class.isAssignableFrom(descriptor.getClassType())) {
            return this.entity;
        }
        if (org.openvpms.component.model.lookup.Lookup.class.isAssignableFrom(descriptor.getClassType())) {
            return this.lookup;
        }
        return this.defaultHandler;
    }
}

