/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tools.security.loader;

import java.io.FileReader;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.query.Query;
import org.openvpms.component.business.domain.im.act.Act;
import org.openvpms.component.business.domain.im.act.ActRelationship;
import org.openvpms.component.business.domain.im.archetype.descriptor.ActionTypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionTypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.Entity;
import org.openvpms.component.business.domain.im.common.EntityIdentity;
import org.openvpms.component.business.domain.im.common.EntityRelationship;
import org.openvpms.component.business.domain.im.common.Participation;
import org.openvpms.component.business.domain.im.lookup.Lookup;
import org.openvpms.component.business.domain.im.lookup.LookupRelationship;
import org.openvpms.component.business.domain.im.party.Contact;
import org.openvpms.component.business.domain.im.product.ProductPrice;
import org.openvpms.component.business.domain.im.security.ArchetypeAwareGrantedAuthority;
import org.openvpms.component.business.domain.im.security.SecurityRole;
import org.openvpms.component.business.domain.im.security.User;
import org.openvpms.tools.security.loader.AuthorityData;
import org.openvpms.tools.security.loader.Role;
import org.openvpms.tools.security.loader.RoleData;
import org.openvpms.tools.security.loader.SecurityData;
import org.openvpms.tools.security.loader.UserData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityLoader {
    public static final ThreadLocal<Session> session = new ThreadLocal();
    private SessionFactory sessionFactory;
    private SecurityData data;
    private static final Logger logger = LoggerFactory.getLogger(SecurityLoader.class);

    public SecurityLoader(String fileName) throws Exception {
        this.init();
        this.data = SecurityData.unmarshal(new FileReader(fileName));
    }

    public void closeSession() throws Exception {
        Session s = session.get();
        session.remove();
        if (s != null) {
            s.close();
        }
    }

    public static void main(String[] args) throws Exception {
        logger.info("Start Loading Security Data");
        SecurityLoader loader = new SecurityLoader(args[0]);
        loader.processRoles();
        loader.processUsers();
        logger.info("End Loading Security Data");
    }

    protected void processRoles() throws Exception {
        Session session = this.currentSession();
        for (RoleData roleData : this.data.getRoleData()) {
            this.deleteIfRoleExists(session, roleData.getName());
            Transaction tx = session.beginTransaction();
            SecurityRole secRole = new SecurityRole();
            secRole.setArchetypeIdAsString("openvpms-system-security.role.1.0");
            secRole.setName(roleData.getName());
            secRole.setDescription(roleData.getDescription());
            for (AuthorityData authData : roleData.getAuthorityData()) {
                ArchetypeAwareGrantedAuthority auth = new ArchetypeAwareGrantedAuthority();
                auth.setArchetypeIdAsString("openvpms-system-security.archetypeAuthority.1.0");
                auth.setName(authData.getName());
                auth.setDescription(authData.getDescription());
                auth.setServiceName(authData.getService());
                auth.setMethod(authData.getMethod());
                auth.setShortName(authData.getArchShortName());
                secRole.addAuthority(auth);
            }
            session.saveOrUpdate((Object)secRole);
            tx.commit();
            logger.info("Loaded role " + roleData.getName());
        }
    }

    protected void processUsers() throws Exception {
        Session session = this.currentSession();
        for (UserData userData : this.data.getUserData()) {
            this.deleteIfUserExists(session, userData.getName());
            Transaction tx = session.beginTransaction();
            User user = new User();
            user.setArchetypeIdAsString("openvpms-system-security.user.1.0");
            user.setName(userData.getName());
            user.setDescription(userData.getDescription());
            for (Role role : userData.getRole()) {
                SecurityRole secRole = this.findRoleWithName(session, role.getName());
                user.addRole(secRole);
            }
            session.saveOrUpdate((Object)user);
            tx.commit();
            logger.info("Loaded user " + userData.getName());
        }
    }

    private SecurityRole findRoleWithName(Session session, String name) {
        Query query = session.getNamedQuery("securityRole.getByName");
        query.setString("name", name);
        List list = query.list();
        if (list.size() == 0) {
            throw new RuntimeException("Could not locate a role with name:" + name);
        }
        if (list.size() > 1) {
            throw new RuntimeException("More than one record with role name: " + name);
        }
        return (SecurityRole)list.get(0);
    }

    private void deleteIfRoleExists(Session session, String name) throws Exception {
        Transaction tx = session.beginTransaction();
        Query query = session.getNamedQuery("securityRole.getByName");
        query.setString("name", name);
        List list = query.list();
        for (Object role : list) {
            SecurityRole secRole = (SecurityRole)role;
            session.delete(role);
        }
        tx.commit();
    }

    private void deleteIfUserExists(Session session, String name) throws Exception {
        Transaction tx = session.beginTransaction();
        Query query = session.getNamedQuery("user.getByName");
        query.setString("name", name);
        List list = query.list();
        for (Object role : list) {
            session.delete(role);
        }
        tx.commit();
    }

    private void init() throws Exception {
        Configuration config = new Configuration();
        config.addClass(Contact.class);
        config.addClass(Entity.class);
        config.addClass(Act.class);
        config.addClass(ActRelationship.class);
        config.addClass(Participation.class);
        config.addClass(EntityRelationship.class);
        config.addClass(EntityIdentity.class);
        config.addClass(Lookup.class);
        config.addClass(LookupRelationship.class);
        config.addClass(ArchetypeDescriptor.class);
        config.addClass(NodeDescriptor.class);
        config.addClass(AssertionDescriptor.class);
        config.addClass(AssertionTypeDescriptor.class);
        config.addClass(ActionTypeDescriptor.class);
        config.addClass(ProductPrice.class);
        config.addClass(SecurityRole.class);
        config.addClass(ArchetypeAwareGrantedAuthority.class);
        this.sessionFactory = config.buildSessionFactory();
    }

    private Session currentSession() throws Exception {
        Session s = session.get();
        if (s == null) {
            s = this.sessionFactory.openSession();
            session.set(s);
        }
        return s;
    }
}

