/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tools.archetype.comparator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.tools.archetype.comparator.DescriptorChange;
import org.openvpms.tools.archetype.comparator.FieldChange;
import org.openvpms.tools.archetype.comparator.NodeChange;

public class ArchetypeChange
extends DescriptorChange<ArchetypeDescriptor> {
    private final List<FieldChange> fieldChanges;
    private final List<NodeChange> nodeChanges;

    public ArchetypeChange(ArchetypeDescriptor oldVersion, ArchetypeDescriptor newVersion) {
        this(oldVersion, newVersion, Collections.emptyList(), Collections.emptyList());
    }

    public ArchetypeChange(ArchetypeDescriptor oldVersion, ArchetypeDescriptor newVersion, List<FieldChange> fieldChanges, List<NodeChange> nodeChanges) {
        super(oldVersion, newVersion);
        this.fieldChanges = fieldChanges;
        this.nodeChanges = nodeChanges;
    }

    public String getShortName() {
        return this.getOldVersion() != null ? ((ArchetypeDescriptor)this.getOldVersion()).getArchetypeType() : ((ArchetypeDescriptor)this.getNewVersion()).getArchetypeType();
    }

    public List<FieldChange> getFieldChanges() {
        return this.fieldChanges;
    }

    public List<NodeChange> getNodeChanges() {
        return this.nodeChanges;
    }

    public boolean hasChangedDerivedNodes() {
        if (this.isUpdate()) {
            Map<String, NodeDescriptor> oldNodes = this.getDerivedNodes((ArchetypeDescriptor)this.getOldVersion());
            Map<String, NodeDescriptor> newNodes = this.getDerivedNodes((ArchetypeDescriptor)this.getNewVersion());
            if (oldNodes.size() != newNodes.size()) {
                return true;
            }
            for (NodeDescriptor oldNode : oldNodes.values()) {
                NodeDescriptor newNode = newNodes.get(oldNode.getName());
                if (newNode == null) {
                    return true;
                }
                if (Objects.equals(oldNode.getPath(), newNode.getPath()) && Objects.equals(oldNode.getDerivedValue(), newNode.getDerivedValue())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean hasAddedAssertions(String ... assertions) {
        if (this.isUpdate()) {
            for (NodeDescriptor oldNode : ((ArchetypeDescriptor)this.getOldVersion()).getNodeDescriptors()) {
                String name = oldNode.getName();
                NodeDescriptor newNode = ((ArchetypeDescriptor)this.getNewVersion()).getNodeDescriptor(name);
                if (newNode == null || !this.hasAddedAssertions(oldNode, newNode, assertions)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getNodesWithAddedAssertions(String ... assertions) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isUpdate()) {
            for (NodeDescriptor oldNode : ((ArchetypeDescriptor)this.getOldVersion()).getNodeDescriptors()) {
                String name = oldNode.getName();
                NodeDescriptor newNode = ((ArchetypeDescriptor)this.getNewVersion()).getNodeDescriptor(name);
                if (newNode == null || !this.hasAddedAssertions(oldNode, newNode, assertions)) continue;
                result.add(name);
            }
        }
        return result;
    }

    private boolean hasAddedAssertions(NodeDescriptor oldNode, NodeDescriptor newNode, String ... assertions) {
        Map oldAssertions = oldNode.getAssertionDescriptors();
        Map newAssertions = newNode.getAssertionDescriptors();
        if (assertions.length == 0) {
            return !oldAssertions.keySet().equals(newAssertions.keySet());
        }
        for (String assertion : assertions) {
            boolean foundNew = newAssertions.containsKey(assertion);
            boolean foundOld = oldAssertions.containsKey(assertion);
            if (!foundNew || foundOld) continue;
            return true;
        }
        return false;
    }

    private Map<String, NodeDescriptor> getDerivedNodes(ArchetypeDescriptor descriptor) {
        HashMap<String, NodeDescriptor> result = new HashMap<String, NodeDescriptor>();
        for (NodeDescriptor node : descriptor.getNodeDescriptors()) {
            if (!node.isDerived()) continue;
            result.put(node.getName(), node);
        }
        return result;
    }
}

