/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.util;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;

public class BlockingExecutor<T> {
    private final Set<T> keys = new HashSet<T>();

    public void run(T key, Runnable command) throws InterruptedException {
        try {
            this.lock(key);
            command.run();
        }
        finally {
            this.unlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V get(T key, Supplier<V> supplier) throws InterruptedException {
        V result;
        try {
            this.lock(key);
            result = supplier.get();
        }
        finally {
            this.unlock(key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock(T key) throws InterruptedException {
        Set<T> set = this.keys;
        synchronized (set) {
            while (!this.keys.add(key)) {
                this.keys.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(T key) {
        Set<T> set = this.keys;
        synchronized (set) {
            this.keys.remove(key);
            this.keys.notifyAll();
        }
    }
}

