/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query.criteria;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.query.criteria.Subquery;
import org.openvpms.component.system.common.query.criteria.Context;
import org.openvpms.component.system.common.query.criteria.ExpressionImpl;
import org.openvpms.component.system.common.query.criteria.PredicateImpl;
import org.openvpms.component.system.common.query.criteria.RootImpl;
import org.openvpms.component.system.common.query.criteria.Type;

public class SubqueryImpl<T>
extends ExpressionImpl<T>
implements Subquery<T> {
    private Expression<T> selection;
    private boolean distinct;
    private List<RootImpl<? extends IMObject>> roots = new ArrayList<RootImpl<? extends IMObject>>();
    private Expression<Boolean> where;

    public SubqueryImpl(Class<T> type, Context context) {
        super(new Type<T>(type), context);
    }

    public <X extends IMObject> Root<X> from(Class<X> type, String ... archetypes) {
        Context context = this.getContext();
        RootImpl<X> root = new RootImpl<X>(context.getType(type, archetypes), context);
        this.roots.add(root);
        return root;
    }

    public <X extends IMObject> Root<X> from(Class<X> type, Collection<String> archetypes) {
        return this.from(type, archetypes.toArray(new String[0]));
    }

    public List<RootImpl<? extends IMObject>> getRoots() {
        return this.roots;
    }

    public Subquery<T> select(Expression<T> expression) {
        this.selection = expression;
        return this;
    }

    public Expression<T> getSelect() {
        return this.selection;
    }

    public Subquery<T> distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public boolean getDistinct() {
        return this.distinct;
    }

    public Subquery<T> where(Expression<Boolean> expression) {
        this.where = expression;
        return this;
    }

    public Subquery<T> where(Predicate ... predicates) {
        return this.where(Arrays.asList(predicates));
    }

    public Subquery<T> where(List<Predicate> predicates) {
        this.where = new PredicateImpl(this.getContext(), new ArrayList<Predicate>(predicates), Predicate.BooleanOperator.AND);
        return this;
    }

    public Expression<Boolean> getWhere() {
        return this.where;
    }
}

