/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openvpms.component.system.common.query.ArchetypeQueryException;
import org.openvpms.component.system.common.query.SortConstraint;

public class NodeSortConstraint
extends SortConstraint {
    private static final long serialVersionUID = 2L;
    private final String alias;
    private final String nodeName;

    public NodeSortConstraint(String nodeName) {
        this(nodeName, true);
    }

    public NodeSortConstraint(String nodeName, boolean ascending) {
        this(null, nodeName, ascending);
    }

    public NodeSortConstraint(String alias, String nodeName) {
        this(alias, nodeName, true);
    }

    public NodeSortConstraint(String alias, String nodeName, boolean ascending) {
        super(ascending);
        if (StringUtils.isEmpty((CharSequence)nodeName)) {
            throw new ArchetypeQueryException(ArchetypeQueryException.ErrorCode.MustSpecifyNodeName);
        }
        if (alias == null) {
            int index = nodeName.indexOf(".");
            if (index != -1) {
                this.alias = nodeName.substring(0, index);
                this.nodeName = nodeName.substring(index + 1);
            } else {
                this.alias = null;
                this.nodeName = nodeName;
            }
        } else {
            this.alias = alias;
            this.nodeName = nodeName;
        }
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NodeSortConstraint)) {
            return false;
        }
        NodeSortConstraint rhs = (NodeSortConstraint)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.nodeName, (Object)rhs.nodeName).isEquals();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("nodeName", (Object)this.nodeName).toString();
    }
}

