/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query;

import java.util.Arrays;
import java.util.List;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.AbstractNodeConstraint;
import org.openvpms.component.system.common.query.AndConstraint;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.CollectionNodeConstraint;
import org.openvpms.component.system.common.query.ExistsConstraint;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IdConstraint;
import org.openvpms.component.system.common.query.IsAConstraint;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.NotConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.ObjectRefNodeConstraint;
import org.openvpms.component.system.common.query.OrConstraint;
import org.openvpms.component.system.common.query.RelationalOp;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;

public class Constraints {
    public static IdConstraint idEq(String source, String target) {
        return new IdConstraint(source, target);
    }

    public static AbstractNodeConstraint eq(String name, Object value) {
        return value instanceof IMObject ? Constraints.eq(name, ((IMObject)value).getObjectReference()) : new NodeConstraint(name, value);
    }

    public static ObjectRefNodeConstraint eq(String name, Reference value) {
        return new ObjectRefNodeConstraint(name, value);
    }

    public static ObjectRefNodeConstraint eq(String name, ArchetypeId value) {
        return new ObjectRefNodeConstraint(name, value);
    }

    public static AbstractNodeConstraint ne(String name, Object value) {
        return value instanceof IMObject ? Constraints.ne(name, ((IMObject)value).getObjectReference()) : new NodeConstraint(name, RelationalOp.NE, value);
    }

    public static ObjectRefNodeConstraint ne(String name, Reference value) {
        return new ObjectRefNodeConstraint(name, RelationalOp.NE, value);
    }

    public static NodeConstraint lt(String name, Object value) {
        return new NodeConstraint(name, RelationalOp.LT, value);
    }

    public static NodeConstraint lte(String name, Object value) {
        return new NodeConstraint(name, RelationalOp.LTE, value);
    }

    public static NodeConstraint gt(String name, Object value) {
        return new NodeConstraint(name, RelationalOp.GT, value);
    }

    public static NodeConstraint gte(String name, Object value) {
        return new NodeConstraint(name, RelationalOp.GTE, value);
    }

    public static NodeConstraint between(String name, Object lo, Object hi) {
        return new NodeConstraint(name, RelationalOp.BTW, lo, hi);
    }

    public static NodeConstraint in(String name, Object ... values) {
        return new NodeConstraint(name, RelationalOp.IN, values);
    }

    public static NodeConstraint isNull(String name) {
        return new NodeConstraint(name, RelationalOp.IS_NULL);
    }

    public static NodeConstraint notNull(String name) {
        return new NodeConstraint(name, RelationalOp.NOT_NULL);
    }

    public static ShortNameConstraint shortName(String shortName) {
        return Constraints.shortName(shortName, false);
    }

    public static ShortNameConstraint shortName(String shortName, boolean activeOnly) {
        return new ShortNameConstraint(shortName, false, activeOnly);
    }

    public static ShortNameConstraint shortName(String alias, String shortName) {
        return Constraints.shortName(alias, shortName, false);
    }

    public static ShortNameConstraint shortName(String alias, String shortName, boolean activeOnly) {
        return new ShortNameConstraint(alias, shortName, false, activeOnly);
    }

    public static ShortNameConstraint shortName(String[] shortNames) {
        return Constraints.shortName(shortNames, false);
    }

    public static ShortNameConstraint shortName(String[] shortNames, boolean activeOnly) {
        return new ShortNameConstraint(shortNames, false, activeOnly);
    }

    public static ShortNameConstraint shortName(String alias, List<String> shortNames) {
        return Constraints.shortName(alias, shortNames.toArray(new String[0]));
    }

    public static ShortNameConstraint shortName(String alias, String[] shortNames) {
        return Constraints.shortName(alias, shortNames, false);
    }

    public static ShortNameConstraint shortName(String alias, String[] shortNames, boolean activeOnly) {
        return new ShortNameConstraint(alias, shortNames, false, activeOnly);
    }

    public static IsAConstraint isA(String name, String ... shortNames) {
        return new IsAConstraint(name, shortNames);
    }

    public static JoinConstraint join(String name) {
        return new CollectionNodeConstraint(name);
    }

    public static JoinConstraint join(String name, String alias) {
        JoinConstraint result = Constraints.join(name);
        result.setAlias(alias);
        return result;
    }

    public static JoinConstraint join(String name, BaseArchetypeConstraint constraint) {
        return new CollectionNodeConstraint(name, constraint);
    }

    public static JoinConstraint leftJoin(String name) {
        return new CollectionNodeConstraint(name).setJoinType(JoinConstraint.JoinType.LeftOuterJoin);
    }

    public static JoinConstraint leftJoin(String name, String alias) {
        JoinConstraint result = Constraints.leftJoin(name);
        result.setAlias(alias);
        return result;
    }

    public static JoinConstraint leftJoin(String name, BaseArchetypeConstraint constraint) {
        return new CollectionNodeConstraint(name, constraint).setJoinType(JoinConstraint.JoinType.LeftOuterJoin);
    }

    public static JoinConstraint leftJoin(String name, String alias, BaseArchetypeConstraint constraint) {
        JoinConstraint result = Constraints.leftJoin(name, constraint);
        result.setAlias(alias);
        return result;
    }

    public static AndConstraint and(IConstraint ... constraints) {
        AndConstraint result = new AndConstraint();
        result.setConstraints(Arrays.asList(constraints));
        return result;
    }

    public static OrConstraint or(IConstraint ... constraints) {
        OrConstraint result = new OrConstraint();
        for (IConstraint constraint : constraints) {
            result.add(constraint);
        }
        return result;
    }

    public static SortConstraint sort(String name) {
        return Constraints.sort(null, name);
    }

    public static SortConstraint sort(String alias, String name) {
        return Constraints.sort(alias, name, true);
    }

    public static SortConstraint sort(String name, boolean ascending) {
        return Constraints.sort(null, name, ascending);
    }

    public static SortConstraint sort(String alias, String name, boolean ascending) {
        return new NodeSortConstraint(alias, name, ascending);
    }

    public static NotConstraint not(IConstraint constraint) {
        return new NotConstraint(constraint);
    }

    public static ExistsConstraint exists(ArchetypeQuery query) {
        return new ExistsConstraint(query);
    }

    public static NotConstraint notExists(ArchetypeQuery query) {
        return Constraints.not(Constraints.exists(query));
    }

    public static ArchetypeQuery subQuery(String shortName, String alias) {
        return new ArchetypeQuery(Constraints.shortName(alias, shortName));
    }

    public static ArchetypeQuery subQuery(String[] shortNames, String alias) {
        ShortNameConstraint constraint = Constraints.shortName(shortNames);
        constraint.setAlias(alias);
        return new ArchetypeQuery(constraint);
    }

    public static ArchetypeQuery subQuery(IMObject object, String alias) {
        return new ArchetypeQuery(new ObjectRefConstraint(alias, object.getObjectReference()));
    }
}

