/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.jxpath;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.jxpath.ExpressionContext;
import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.functions.MethodFunction;
import org.apache.commons.jxpath.util.MethodLookupUtils;

public class AbstractObjectFunctions
implements Functions {
    private final Object[] zeroArgs = new Object[1];
    private final String namespace;
    private Object object;
    private Class<?> objectClass;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public AbstractObjectFunctions(Object object, String namespace) {
        this(namespace);
        this.setObject(object);
    }

    protected AbstractObjectFunctions(String namespace) {
        this.namespace = namespace;
    }

    public Set<?> getUsedNamespaces() {
        return Collections.singleton(this.namespace);
    }

    public Function getFunction(String namespace, String name, Object[] parameters) {
        Method method;
        if (!namespace.equals(this.namespace)) {
            return null;
        }
        if (parameters == null) {
            parameters = EMPTY_ARRAY;
        }
        if ((method = MethodLookupUtils.lookupStaticMethod(this.objectClass, (String)name, (Object[])parameters)) != null && Modifier.isStatic(method.getModifiers())) {
            return new MethodFunction(method);
        }
        Object[] params = this.getParameters(parameters);
        method = MethodLookupUtils.lookupMethod(this.objectClass, (String)name, (Object[])params);
        if (method != null) {
            return new MethodFunction(method){

                public Object invoke(ExpressionContext context, Object[] parameters) {
                    return super.invoke(context, AbstractObjectFunctions.this.getParameters(parameters));
                }
            };
        }
        return null;
    }

    protected void setObject(Object object) {
        this.object = object;
        this.objectClass = object.getClass();
        this.zeroArgs[0] = object;
    }

    private Object[] getParameters(Object[] parameters) {
        Object[] result;
        if (parameters == null || parameters.length == 0) {
            result = this.zeroArgs;
        } else {
            result = new Object[parameters.length + 1];
            result[0] = this.object;
            System.arraycopy(parameters, 0, result, 1, parameters.length);
        }
        return result;
    }
}

