/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.cache;

import java.util.Map;
import java.util.Objects;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.IMObjectCache;

public abstract class AbstractIMObjectCache
implements IMObjectCache {
    private final Map<Object, IMObject> cache;
    private final ArchetypeService service;

    protected AbstractIMObjectCache(Map<Object, IMObject> cache, ArchetypeService service) {
        this.cache = cache;
        this.service = service;
    }

    @Override
    public synchronized void add(IMObject object) {
        Reference reference = object.getObjectReference();
        this.add(reference, object);
    }

    @Override
    public synchronized void remove(IMObject object) {
        Reference reference = object.getObjectReference();
        this.cache.remove(reference);
        if (!reference.isNew()) {
            this.cache.remove(new SecondaryKey(reference));
        }
    }

    @Override
    public synchronized IMObject get(Reference reference) {
        return this.retrieve(reference, null);
    }

    @Override
    public <T extends IMObject> T get(Reference reference, Class<T> type) {
        return (T)((IMObject)type.cast(this.get(reference)));
    }

    @Override
    public synchronized IMObject get(Reference reference, boolean active) {
        return this.retrieve(reference, active);
    }

    @Override
    public synchronized IMObject getCached(Reference reference) {
        IMObject result = null;
        if (reference != null && (result = this.cache.get(reference)) == null && !reference.isNew()) {
            result = this.cache.get(new SecondaryKey(reference));
        }
        return result;
    }

    @Override
    public synchronized void clear() {
        this.cache.clear();
    }

    private void add(Reference reference, IMObject object) {
        this.cache.put(reference, object);
        if (!reference.isNew()) {
            this.cache.put(new SecondaryKey(reference), object);
        }
    }

    private IMObject retrieve(Reference reference, Boolean active) {
        IMObject result = null;
        if (reference != null) {
            result = this.getCached(reference);
            if (result != null) {
                if (active != null && result.isActive() != active.booleanValue()) {
                    result = null;
                }
            } else if (this.service != null) {
                IMObject iMObject = result = active == null ? this.service.get(reference) : this.service.get(reference, active.booleanValue());
                if (result != null && !(result instanceof Document)) {
                    this.add(reference, result);
                }
            }
        }
        return result;
    }

    private static final class SecondaryKey {
        private final Reference reference;

        public SecondaryKey(Reference reference) {
            this.reference = reference;
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof SecondaryKey) {
                Reference other = ((SecondaryKey)obj).reference;
                result = this.reference.equals(other.getArchetype(), other.getId());
            }
            return result;
        }

        public int hashCode() {
            return Objects.hash(this.reference.getArchetype(), this.reference.getId());
        }
    }
}

