/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper.lookup;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.helper.LookupHelperException;
import org.openvpms.component.business.service.archetype.helper.lookup.AbstractLookupAssertion;
import org.openvpms.component.model.archetype.AssertionDescriptor;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;

public class TargetLookup
extends AbstractLookupAssertion {
    public static final String TYPE = "targetLookup";
    private final String relationship = this.getProperty("relationship");
    private final String value = this.getProperty("value");

    public TargetLookup(AssertionDescriptor descriptor, ArchetypeService service, LookupService lookupService) {
        super(descriptor, TYPE, service, lookupService);
        if (StringUtils.isEmpty((CharSequence)this.relationship) || StringUtils.isEmpty((CharSequence)this.value)) {
            throw new LookupHelperException(LookupHelperException.ErrorCode.InvalidTargetLookupSpec);
        }
    }

    public String getRelationship() {
        return this.relationship;
    }

    public String[] getArchetypes() {
        return this.getArchetypeShortNames(this.relationship, "target");
    }

    @Override
    public Collection<Lookup> getLookups(IMObject context) {
        Lookup lookup = this.getSourceLookup(context);
        Collection<Object> lookups = lookup != null ? this.getLookupService().getTargetLookups(lookup, this.relationship) : Collections.emptyList();
        return lookups;
    }

    @Override
    public Lookup getLookup(IMObject context, String code) {
        Lookup result = null;
        Lookup source = this.getSourceLookup(context);
        if (source != null) {
            Collection lookups = this.getLookupService().getTargetLookups(source, this.relationship);
            for (Lookup lookup : lookups) {
                if (!code.equals(lookup.getCode())) continue;
                result = lookup;
                break;
            }
        }
        return result;
    }

    @Override
    public String getName(IMObject context, String code) {
        Lookup lookup = this.getLookup(context, code);
        return lookup != null ? lookup.getName() : null;
    }

    private Lookup getSourceLookup(IMObject context) {
        return this.getLookup(context, this.value, this.relationship, "source");
    }
}

