/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import java.util.Collection;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.util.StringUtilities;

public class TypeHelper {
    private TypeHelper() {
    }

    public static boolean isA(IMObject object, String shortName) {
        return object != null && TypeHelper.matches(object.getArchetype(), shortName);
    }

    public static boolean isA(IMObject object, String ... shortNames) {
        if (object != null) {
            for (String shortName : shortNames) {
                if (!TypeHelper.isA(object, shortName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isA(IMObject object, Collection<String> shortNames) {
        if (object != null) {
            for (String shortName : shortNames) {
                if (!TypeHelper.isA(object, shortName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isA(Reference reference, String ... shortNames) {
        if (reference != null) {
            for (String shortName : shortNames) {
                if (!TypeHelper.isA(reference, shortName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isA(Reference reference, String shortName) {
        return reference != null && TypeHelper.matches(reference.getArchetype(), shortName);
    }

    public static boolean isA(ArchetypeId id, String ... shortNames) {
        if (id != null) {
            for (String shortName : shortNames) {
                if (!TypeHelper.matches(id, shortName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isA(String id, String ... shortNames) {
        if (id != null) {
            for (String shortName : shortNames) {
                if (!TypeHelper.matches(id, shortName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isA(String id, Collection<String> shortNames) {
        if (id != null) {
            for (String shortName : shortNames) {
                if (!TypeHelper.matches(id, shortName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isA(ArchetypeDescriptor descriptor, String ... shortNames) {
        if (descriptor != null) {
            for (String shortName : shortNames) {
                if (!TypeHelper.matches(descriptor.getArchetypeType(), shortName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isA(ArchetypeDescriptor descriptor, String shortName) {
        if (descriptor != null) {
            return TypeHelper.matches(descriptor.getArchetypeType(), shortName);
        }
        return false;
    }

    public static boolean matches(ArchetypeId id, String shortName) {
        return TypeHelper.matches(id.getShortName(), shortName);
    }

    public static boolean matches(String shortName, String wildcard) {
        return StringUtilities.matches(shortName, wildcard);
    }

    public static boolean matches(String[] shortNames, String wildcard) {
        for (String shortName : shortNames) {
            if (TypeHelper.matches(shortName, wildcard)) continue;
            return false;
        }
        return true;
    }
}

