/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.assertion;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jxpath.JXPathContext;
import org.openvpms.component.business.domain.im.archetype.descriptor.ActionContext;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.model.archetype.NamedProperty;
import org.openvpms.component.system.common.jxpath.JXPathHelper;

public class ExpressionAssertions {
    private static final Pattern PATTERN = Pattern.compile("\\p{Alpha}[\\w|/]*\\(?");

    private ExpressionAssertions() {
    }

    public static boolean validate(ActionContext context) {
        JXPathContext pathContext;
        Object result;
        NamedProperty property = context.getProperty("expression");
        String expression = (String)property.getValue();
        ArchetypeDescriptor archetype = ExpressionAssertions.getArchetypeDescriptor(context.getNode());
        if (archetype != null) {
            expression = ExpressionAssertions.getExpression(archetype, expression);
        }
        return (result = (pathContext = JXPathHelper.newContext(context.getParent())).getValue(expression, Boolean.class)) != null && (Boolean)result != false;
    }

    private static String getExpression(ArchetypeDescriptor descriptor, String expression) {
        Matcher matcher = PATTERN.matcher(expression);
        int start = 0;
        StringBuilder result = new StringBuilder();
        while (matcher.find(start)) {
            String match = matcher.group();
            result.append(expression, start, matcher.start());
            if (!match.matches("(.*[/(].*)")) {
                NodeDescriptor node = descriptor.getNodeDescriptor(match);
                if (node != null) {
                    result.append(node.getPath());
                } else {
                    result.append(match);
                }
            } else {
                result.append(match);
            }
            start = matcher.end();
        }
        result.append(expression.substring(start));
        return result.toString();
    }

    private static ArchetypeDescriptor getArchetypeDescriptor(NodeDescriptor node) {
        ArchetypeDescriptor result = null;
        while (result == null && node != null) {
            if (node.getArchetypeDescriptor() != null) {
                result = node.getArchetypeDescriptor();
                continue;
            }
            result = ExpressionAssertions.getArchetypeDescriptor(node.getParent());
        }
        return result;
    }
}

