/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.assertion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.openvpms.component.business.domain.im.archetype.descriptor.ActionContext;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionDescriptor;
import org.openvpms.component.business.domain.im.common.PeriodRelationship;
import org.openvpms.component.business.service.archetype.assertion.AbstractRelationshipAssertions;

public class EntityRelationshipAssertions
extends AbstractRelationshipAssertions {
    public static final String UNIQUE_ENTITY_RELATIONSHIP = "uniqueEntityRelationship";
    private static final EntityRelationshipAssertions instance = new EntityRelationshipAssertions();

    private EntityRelationshipAssertions() {
    }

    public static boolean validate(ActionContext context) {
        return instance.isValid(context);
    }

    protected boolean isValid(ActionContext context) {
        Collection<PeriodRelationship> entries;
        boolean result = false;
        AssertionDescriptor assertion = context.getAssertion();
        if (UNIQUE_ENTITY_RELATIONSHIP.equals(assertion.getName()) && (entries = this.getObjects(context.getValue(), PeriodRelationship.class)) != null) {
            result = this.checkUnique(entries);
        }
        return result;
    }

    protected boolean checkUnique(Collection<PeriodRelationship> entries) {
        if (entries.size() > 1) {
            Date now = new Date();
            ArrayList active = new ArrayList();
            for (PeriodRelationship entry : entries) {
                if (!entry.isActive(now) || !this.contains(entry, active)) continue;
                return false;
            }
        }
        return true;
    }
}

