/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype;

import java.util.Collection;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.ArchetypeServiceException;
import org.openvpms.component.business.service.archetype.IMObjectFactory;
import org.openvpms.component.business.service.archetype.JXPathGenericObjectCreationFactory;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.component.system.common.util.ClassHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIMObjectFactory
implements IMObjectFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractIMObjectFactory.class);

    @Override
    public IMObject create(String shortName) {
        ArchetypeDescriptor desc = this.getArchetypeDescriptor(shortName);
        return desc != null ? this.create(desc) : null;
    }

    @Override
    public IMObject create(ArchetypeId id) {
        ArchetypeDescriptor desc = this.getArchetypeDescriptor(id);
        return desc != null ? this.create(desc) : null;
    }

    protected abstract ArchetypeDescriptor getArchetypeDescriptor(String var1);

    protected ArchetypeDescriptor getArchetypeDescriptor(ArchetypeId id) {
        return this.getArchetypeDescriptor(id.getShortName());
    }

    protected IMObject create(ArchetypeDescriptor descriptor) {
        IMObject result;
        Class<?> domainClass;
        String className = descriptor.getClassName();
        try {
            domainClass = ClassHelper.getClass(className);
        }
        catch (ClassNotFoundException exception) {
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.InvalidDomainClass, className);
        }
        if (!IMObject.class.isAssignableFrom(domainClass)) {
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.InvalidDomainClass, className);
        }
        try {
            result = (IMObject)domainClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            result.setArchetypeId(descriptor.getType());
            JXPathContext context = JXPathHelper.newContext(result);
            context.setFactory((AbstractFactory)new JXPathGenericObjectCreationFactory());
            this.create(context, descriptor.getNodeDescriptorsAsArray());
        }
        catch (Exception exception) {
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToCreateObject, exception, descriptor.getType().getShortName());
        }
        return result;
    }

    private void create(JXPathContext context, NodeDescriptor[] nodes) {
        for (NodeDescriptor node : nodes) {
            if (node.isCollection() || node.getNodeDescriptorCount() > 0 || !StringUtils.isEmpty((CharSequence)node.getDefaultValue())) {
                this.create(context, node);
            }
            for (AssertionDescriptor assertion : node.getAssertionDescriptorsAsArray()) {
                try {
                    assertion.create(context.getContextBean(), node);
                }
                catch (Exception exception) {
                    throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToExecuteCreateFunction, exception, assertion.getName());
                }
            }
            if (node.getNodeDescriptors().size() <= 0) continue;
            this.create(context, node.getNodeDescriptorsAsArray());
        }
    }

    private void create(JXPathContext context, NodeDescriptor node) {
        log.debug("Attempting to create path={} for node={}", (Object)node.getPath(), (Object)node.getName());
        context.getVariables().declareVariable("node", (Object)node);
        context.createPath(node.getPath());
        String expression = node.getDefaultValue();
        if (!StringUtils.isEmpty((CharSequence)expression)) {
            log.debug("evaluating default value expression for node={}, path={}, expression={}", new Object[]{node.getName(), node.getPath(), expression});
            Object value = context.getValue(expression);
            IMObject object = (IMObject)context.getContextBean();
            if (node.isCollection()) {
                if (value != null) {
                    if (Collection.class.isAssignableFrom(value.getClass())) {
                        for (Object v : (Collection)value) {
                            node.addChildToCollection(object, v);
                        }
                    } else {
                        node.addChildToCollection(object, value);
                    }
                }
            } else {
                node.setValue(object, value);
            }
        }
    }
}

