/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.interceptor;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.hibernate.EmptyInterceptor;
import org.hibernate.SessionFactory;
import org.hibernate.type.Type;
import org.openvpms.component.business.dao.hibernate.cache.ArchetypeIdCache;
import org.openvpms.component.business.dao.hibernate.im.common.AuditableIMObjectDO;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectAssembler;
import org.openvpms.component.business.dao.hibernate.im.security.UserDO;
import org.openvpms.component.business.dao.hibernate.im.security.UserDOImpl;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.service.security.AuthenticationContext;
import org.openvpms.component.model.user.User;

public class IMObjectInterceptor
extends EmptyInterceptor {
    private final transient AuthenticationContext context;
    private final transient ArchetypeIdCache cache;
    private SessionFactory factory;
    static final String CREATED = "created";
    static final String CREATED_BY = "createdBy";
    static final String UPDATED = "updated";
    static final String UPDATED_BY = "updatedBy";

    public IMObjectInterceptor(AuthenticationContext context) {
        this(context, new ArchetypeIdCache());
    }

    public IMObjectInterceptor(AuthenticationContext context, ArchetypeIdCache cache) {
        this.context = context;
        this.cache = cache;
    }

    @Resource
    public void setSessionFactory(SessionFactory factory) {
        this.factory = factory;
    }

    public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        boolean modified = false;
        for (int i = 0; i < state.length; ++i) {
            Object object = state[i];
            if (!(object instanceof ArchetypeId)) continue;
            state[i] = this.cache.get((ArchetypeId)object);
            modified = true;
        }
        return modified;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        boolean modified = false;
        if (entity instanceof AuditableIMObjectDO) {
            modified = this.populate(UPDATED, currentState, propertyNames, IMObjectAssembler.getTimestampNow(), true);
            modified |= this.populate(UPDATED_BY, currentState, propertyNames, this.getUser(), false);
        }
        return modified;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        boolean modified = false;
        if (entity instanceof AuditableIMObjectDO) {
            modified = this.populate(CREATED, state, propertyNames, IMObjectAssembler.getTimestampNow(), true);
            modified |= this.populate(CREATED_BY, state, propertyNames, this.getUser(), true);
            modified |= this.populate(UPDATED, state, propertyNames, null, true);
            modified |= this.populate(UPDATED_BY, state, propertyNames, null, true);
        }
        return modified;
    }

    protected UserDO resolve(User user) {
        return (UserDO)this.factory.getCurrentSession().load(UserDOImpl.class, (Serializable)Long.valueOf(user.getId()));
    }

    private boolean populate(String name, Object[] state, String[] propertyNames, Object value, boolean useNull) {
        int index = ArrayUtils.indexOf((Object[])propertyNames, (Object)name);
        if (index != -1 && (value != null || useNull) && !Objects.equals(value, state[index])) {
            state[index] = value;
            return true;
        }
        return false;
    }

    private UserDO getUser() {
        UserDO result = null;
        User user = this.context.getUser();
        if (user != null && !user.isNew()) {
            result = this.resolve(user);
        }
        return result;
    }
}

