/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openvpms.component.business.dao.hibernate.im.common.Assembler;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDO;
import org.openvpms.component.business.dao.hibernate.im.entity.AbstractNodeResultCollector;
import org.openvpms.component.business.dao.im.common.IMObjectDAOException;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;

public class IMObjectNodeResultCollector
extends AbstractNodeResultCollector<IMObject> {
    private final List<IMObject> result = new ArrayList<IMObject>();

    public IMObjectNodeResultCollector(IArchetypeDescriptorCache cache, Collection<String> nodes) {
        super(cache, nodes);
    }

    @Override
    public void collect(Object object) {
        if (!(object instanceof IMObjectDO)) {
            throw new IMObjectDAOException(IMObjectDAOException.ErrorCode.CannotCollectObject, object.getClass().getName());
        }
        Context context = this.getContext();
        Assembler assembler = context.getAssembler();
        IMObject obj = assembler.assemble((IMObjectDO)object, context);
        for (NodeDescriptor descriptor : this.getDescriptors(obj)) {
            this.loadValue(descriptor, obj);
        }
        this.result.add(obj);
    }

    @Override
    protected List<IMObject> getResults() {
        return this.result;
    }
}

