/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.entity;

import java.util.HashSet;
import java.util.Set;
import org.openvpms.component.business.dao.hibernate.im.common.AuditableIMObjectDOImpl;
import org.openvpms.component.business.dao.hibernate.im.entity.EntityDO;
import org.openvpms.component.business.dao.hibernate.im.entity.EntityIdentityDO;
import org.openvpms.component.business.dao.hibernate.im.entity.EntityLinkDO;
import org.openvpms.component.business.dao.hibernate.im.entity.EntityRelationshipDO;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupDO;
import org.openvpms.component.business.domain.archetype.ArchetypeId;

public class EntityDOImpl
extends AuditableIMObjectDOImpl
implements EntityDO {
    private Set<EntityIdentityDO> identities = new HashSet<EntityIdentityDO>();
    private Set<EntityRelationshipDO> sourceEntityRelationships = new HashSet<EntityRelationshipDO>();
    private Set<EntityRelationshipDO> targetEntityRelationships = new HashSet<EntityRelationshipDO>();
    private Set<EntityLinkDO> links = new HashSet<EntityLinkDO>();
    private Set<LookupDO> classifications = new HashSet<LookupDO>();

    public EntityDOImpl() {
    }

    public EntityDOImpl(ArchetypeId archetypeId) {
        this.setArchetypeId(archetypeId);
    }

    @Override
    public Set<EntityIdentityDO> getIdentities() {
        return this.identities;
    }

    @Override
    public void addIdentity(EntityIdentityDO identity) {
        identity.setEntity(this);
        this.identities.add(identity);
    }

    @Override
    public boolean removeIdentity(EntityIdentityDO identity) {
        identity.setEntity(null);
        return this.identities.remove(identity);
    }

    @Override
    public Set<EntityRelationshipDO> getSourceEntityRelationships() {
        return this.sourceEntityRelationships;
    }

    @Override
    public void addSourceEntityRelationship(EntityRelationshipDO source) {
        this.sourceEntityRelationships.add(source);
        source.setSource(this);
    }

    @Override
    public void removeSourceEntityRelationship(EntityRelationshipDO source) {
        this.sourceEntityRelationships.remove(source);
    }

    @Override
    public Set<EntityRelationshipDO> getTargetEntityRelationships() {
        return this.targetEntityRelationships;
    }

    @Override
    public void addTargetEntityRelationship(EntityRelationshipDO target) {
        this.targetEntityRelationships.add(target);
        target.setTarget(this);
    }

    @Override
    public void removeTargetEntityRelationship(EntityRelationshipDO target) {
        this.targetEntityRelationships.remove(target);
    }

    @Override
    public Set<EntityRelationshipDO> getEntityRelationships() {
        HashSet<EntityRelationshipDO> relationships = new HashSet<EntityRelationshipDO>(this.sourceEntityRelationships);
        relationships.addAll(this.targetEntityRelationships);
        return relationships;
    }

    @Override
    public Set<EntityLinkDO> getEntityLinks() {
        return this.links;
    }

    @Override
    public void addEntityLink(EntityLinkDO link) {
        link.setSource(this);
        this.links.add(link);
    }

    @Override
    public void removeEntityLink(EntityLinkDO link) {
        this.links.remove(link);
    }

    @Override
    public Set<LookupDO> getClassifications() {
        return this.classifications;
    }

    @Override
    public void addClassification(LookupDO classification) {
        this.classifications.add(classification);
    }

    @Override
    public void removeClassification(LookupDO classification) {
        this.classifications.remove(classification);
    }

    protected void setSourceEntityRelationships(Set<EntityRelationshipDO> relationships) {
        this.sourceEntityRelationships = relationships;
    }

    protected void setTargetEntityRelationships(Set<EntityRelationshipDO> relationships) {
        this.targetEntityRelationships = relationships;
    }

    protected void setEntityLinks(Set<EntityLinkDO> links) {
        this.links = links;
    }

    protected void setClassifications(Set<LookupDO> classifications) {
        this.classifications = classifications;
    }

    protected void setIdentities(Set<EntityIdentityDO> identities) {
        this.identities = identities;
    }
}

