/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2024 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.component.i18n;

/**
 * Framework messages.
 *
 * @author Tim Anderson
 */
public class FrameworkMessages {

    /**
     * The messages.
     */
    private static final Messages messages = new Messages("FWK", FrameworkMessages.class.getName());

    /**
     * Creates a message indicating that validation has failed.
     *
     * @param archetype the archetype that was used to perform the validation
     * @return a new message
     */
    public static Message failedToValidateObject(String archetype) {
        return messages.create(1, archetype);
    }
}
