/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.model.bean;

import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import java.util.function.Predicate;
import org.openvpms.component.model.bean.AbstractPolicyBuilder;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.bean.PolicyBuilder;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.object.SequencedRelationship;

public class Policies {
    private static final Policy<Relationship> ANY = Policies.newPolicy(Relationship.class).anyObject().build();
    private static final Policy<Relationship> ACTIVE = Policies.newPolicy(Relationship.class).active().build();
    private static final Policy<SequencedRelationship> SEQUENCED = Policies.newPolicy(SequencedRelationship.class).anyObject().orderBySequence().build();
    private static final Policy<SequencedRelationship> REVERSE_SEQUENCED = Policies.newPolicy(SequencedRelationship.class).anyObject().orderBySequence(false).build();

    private Policies() {
    }

    public static Policy<Relationship> active() {
        return ACTIVE;
    }

    public static Policy<Relationship> active(Date time) {
        return Policies.active(time, true);
    }

    public static Policy<Relationship> active(Date time, boolean active) {
        return new DefaultPolicy<Relationship>(active, Relationship.class, Predicates.activeAt(time));
    }

    public static Policy<Relationship> active(Predicate<Relationship> predicate) {
        return new DefaultPolicy<Relationship>(Policy.State.ACTIVE, Relationship.class, predicate);
    }

    public static <R extends Relationship> Policy<R> active(Class<R> type) {
        return new DefaultPolicy<R>(Policy.State.ACTIVE, type, Predicates.activeNow());
    }

    public static <R extends Relationship> Policy<R> active(Class<R> type, Comparator<R> comparator) {
        return new DefaultPolicy<R>(Policy.State.ACTIVE, type, Predicates.activeNow(), comparator);
    }

    public static <R extends Relationship> Policy<R> active(Date time, Class<R> type, Comparator<R> comparator) {
        return new DefaultPolicy<R>(Policy.State.ACTIVE, type, Predicates.activeAt(time), comparator);
    }

    public static Policy<Relationship> any() {
        return ANY;
    }

    public static Policy<Relationship> all() {
        return ANY;
    }

    public static Policy<Relationship> all(Comparator<Relationship> comparator) {
        return Policies.all(Relationship.class, comparator);
    }

    public static <R extends Relationship> Policy<R> all(Class<R> type, Comparator<R> comparator) {
        return new DefaultPolicy<R>(Policy.State.ANY, type, null, comparator);
    }

    public static <R extends Relationship> Policy<R> any(Class<R> type) {
        return new DefaultPolicy<R>(Policy.State.ANY, type, null);
    }

    public static Policy<Relationship> any(Predicate<Relationship> predicate) {
        return new DefaultPolicy<Relationship>(Policy.State.ANY, Relationship.class, predicate);
    }

    public static <R extends Relationship> Policy<R> any(Class<R> type, Predicate<R> predicate) {
        return new DefaultPolicy<R>(Policy.State.ANY, type, predicate);
    }

    public static Policy<Relationship> all(Predicate<Relationship> predicate) {
        return Policies.any(predicate);
    }

    public static Policy<SequencedRelationship> orderBySequence() {
        return Policies.orderBySequence(true);
    }

    public static Policy<SequencedRelationship> orderBySequence(boolean ascending) {
        return ascending ? SEQUENCED : REVERSE_SEQUENCED;
    }

    public static Policy<Relationship> match(boolean active, Predicate<Relationship> predicate) {
        return new DefaultPolicy<Relationship>(active, Relationship.class, predicate);
    }

    public static Policy<Relationship> match(boolean active, Predicate<Relationship> predicate, Comparator<Relationship> comparator) {
        return new DefaultPolicy<Relationship>(active, Relationship.class, predicate, comparator);
    }

    public static <R extends Relationship> Policy<R> match(boolean active, Class<R> type, Predicate<R> predicate) {
        return new DefaultPolicy<R>(active, type, predicate);
    }

    public static <R extends Relationship> PolicyBuilder<R> newPolicy(Class<R> type) {
        return new PolicyBuilderImpl<R>(type);
    }

    static class DefaultPolicy<R extends Relationship>
    implements Policy<R> {
        private final Predicate<R> predicate;
        private final Policy.State state;
        private final Class<R> type;
        private final Comparator<R> comparator;

        DefaultPolicy(boolean active, Class<R> type, Predicate<R> predicate) {
            this(active, type, predicate, null);
        }

        DefaultPolicy(boolean active, Class<R> type, Predicate<R> predicate, Comparator<R> comparator) {
            this(active ? Policy.State.ACTIVE : Policy.State.ANY, type, predicate, comparator);
        }

        DefaultPolicy(Policy.State state, Class<R> type, Predicate<R> predicate) {
            this(state, type, predicate, null);
        }

        DefaultPolicy(Policy.State state, Class<R> type, Predicate<R> predicate, Comparator<R> comparator) {
            this.predicate = predicate;
            this.state = state;
            this.type = type;
            this.comparator = comparator;
        }

        @Override
        public Predicate<R> getPredicate() {
            return this.predicate;
        }

        @Override
        public Policy.State getState() {
            return this.state;
        }

        @Override
        public Comparator<R> getComparator() {
            return this.comparator;
        }

        @Override
        public Class<R> getType() {
            return this.type;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Policy) {
                Policy other = (Policy)obj;
                return Objects.equals(this.predicate, other.getPredicate()) && Objects.equals((Object)this.state, (Object)other.getState()) && Objects.equals(this.type, other.getType()) && Objects.equals(this.comparator, other.getComparator());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.predicate, this.state, this.type, this.comparator});
        }
    }

    static class PolicyBuilderImpl<R extends Relationship>
    extends AbstractPolicyBuilder<R> {
        public PolicyBuilderImpl(Class<R> type) {
            super(type);
        }
    }
}

