/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.model.bean;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.function.Predicate;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.bean.PolicyBuilder;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.object.SequencedRelationship;

public abstract class AbstractPolicyBuilder<R extends Relationship>
implements PolicyBuilder<R> {
    private final Class<R> type;
    private Predicate<R> predicate;
    private Policy.State state = Policy.State.ANY;
    private Comparator<R> comparator;

    protected AbstractPolicyBuilder(Class<R> type) {
        this.type = type;
    }

    @Override
    public PolicyBuilder<R> active() {
        this.predicate = Predicates.activeNow();
        return this.activeObjects();
    }

    @Override
    public PolicyBuilder<R> active(Date time) {
        this.predicate = Predicates.activeAt(time);
        return this.activeObjects();
    }

    @Override
    public PolicyBuilder<R> activeObjects() {
        this.state = Policy.State.ACTIVE;
        return this;
    }

    @Override
    public PolicyBuilder<R> inactiveObjects() {
        this.state = Policy.State.INACTIVE;
        return this;
    }

    @Override
    public PolicyBuilder<R> anyObject() {
        this.state = Policy.State.ANY;
        return this;
    }

    @Override
    public PolicyBuilder<R> predicate(Predicate<R> predicate) {
        return this.and(predicate);
    }

    @Override
    public PolicyBuilder<R> and(Predicate<R> predicate) {
        this.predicate = this.predicate == null ? predicate : this.predicate.and(predicate);
        return this;
    }

    @Override
    public PolicyBuilder<R> or(Predicate<R> predicate) {
        this.predicate = this.predicate == null ? predicate : this.predicate.or(predicate);
        return this;
    }

    @Override
    public PolicyBuilder<R> orderBySequence() {
        return this.orderBySequence(true);
    }

    @Override
    public PolicyBuilder<R> orderBySequence(boolean ascending) {
        if (SequencedRelationship.class.isAssignableFrom(this.type)) {
            Comparator<SequencedRelationship> comparator = Comparator.comparingInt(SequencedRelationship::getSequence);
            this.comparator = ascending ? comparator : Collections.reverseOrder(comparator);
        } else {
            this.comparator = null;
        }
        return this;
    }

    @Override
    public PolicyBuilder<R> comparator(Comparator<R> comparator) {
        this.comparator = comparator;
        return this;
    }

    @Override
    public Policy<R> build() {
        return new Policies.DefaultPolicy<R>(this.state, this.type, this.predicate, this.comparator);
    }
}

