/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.load;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openvpms.etl.load.Node;

public class NodeParser {
    private static final Pattern pattern = Pattern.compile("(\\$(\\w+))?<([^<>]+)>(\\w+)(\\[(\\d+)])?");

    private NodeParser() {
    }

    public static Node parse(String node) {
        Matcher matcher = pattern.matcher(node);
        int start = 0;
        Node result = null;
        Node parent = null;
        while (start < node.length() && matcher.find(start)) {
            if (start != matcher.start()) {
                return null;
            }
            String field = matcher.group(2);
            String archetype = matcher.group(3);
            String name = matcher.group(4);
            String indexStr = matcher.group(6);
            int index = indexStr != null ? Integer.parseInt(indexStr) : -1;
            Node current = new Node(field, archetype, name, index);
            if (parent != null) {
                if (field != null) {
                    return null;
                }
                parent.setChild(current);
            }
            parent = current;
            if (result == null) {
                result = parent;
            }
            start = matcher.end();
        }
        return start == node.length() ? result : null;
    }
}

