/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.load;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.resources.Messages;
import org.openvpms.component.business.dao.im.common.IMObjectDAO;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.lookup.AbstractLookupService;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.lookup.LookupRelationship;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingLookupService
extends AbstractLookupService {
    private final Map<String, Map<String, Lookup>> lookupsByArchetype = new HashMap<String, Map<String, Lookup>>();
    private final Map<Reference, Lookup> lookupsByRef = new HashMap<Reference, Lookup>();
    private final Map<Reference, RelatedLookups> targetLookups = new HashMap<Reference, RelatedLookups>();
    private final Logger log = LoggerFactory.getLogger(CachingLookupService.class);
    private static final Messages messages = Messages.getMessages((String)"org.openvpms.etl.load.messages");

    public CachingLookupService(IArchetypeService service, IMObjectDAO dao) {
        super(service, dao);
    }

    public Lookup getLookup(String shortName, String code) {
        String[] shortNames;
        for (String name : shortNames = this.getShortNames(shortName)) {
            Map<String, Lookup> lookups = this.get(name);
            Lookup lookup = lookups.get(code);
            if (lookup == null) continue;
            return lookup;
        }
        return null;
    }

    public Collection<Lookup> getLookups(String shortName) {
        String[] shortNames = this.getShortNames(shortName);
        ArrayList<Lookup> result = new ArrayList<Lookup>();
        for (String name : shortNames) {
            Map<String, Lookup> lookups = this.get(name);
            result.addAll(lookups.values());
        }
        return result;
    }

    public Lookup getDefaultLookup(String shortName) {
        String[] shortNames;
        for (String name : shortNames = this.getShortNames(shortName)) {
            for (Lookup lookup : this.getLookups(name)) {
                if (!lookup.isDefaultLookup()) continue;
                return lookup;
            }
        }
        return null;
    }

    public synchronized void add(Lookup lookup) {
        this.lookupsByRef.put(lookup.getObjectReference(), lookup);
        String shortName = lookup.getArchetype();
        Map<String, Lookup> lookups = this.get(shortName);
        lookups.put(lookup.getCode(), lookup);
    }

    public synchronized void add(LookupRelationship relationship) {
        Lookup source = null;
        Lookup target = null;
        if (relationship.getSource() != null) {
            source = this.getLookup(relationship.getSource());
        }
        if (relationship.getTarget() != null) {
            target = this.getLookup(relationship.getTarget());
        }
        if (source != null && target != null) {
            source.addLookupRelationship(relationship);
            target.addLookupRelationship(relationship);
            RelatedLookups related = this.getTargets(source);
            related.add(relationship.getArchetype(), target);
        }
    }

    public synchronized Lookup getLookup(Reference reference) {
        String shortName = reference.getArchetype();
        this.get(shortName);
        return this.lookupsByRef.get(reference);
    }

    public Collection<Lookup> getTargetLookups(Lookup lookup) {
        RelatedLookups related = this.getTargets(lookup);
        return related.getLookups();
    }

    public Collection<Lookup> getTargetLookups(Lookup lookup, String relationshipShortName) {
        RelatedLookups related = this.getTargets(lookup);
        Collection targets = related.getLookups(relationshipShortName);
        if (targets == null) {
            targets = super.getTargetLookups(lookup, relationshipShortName);
            related.setLookups(relationshipShortName, targets);
        }
        return targets;
    }

    private synchronized Map<String, Lookup> get(String shortName) {
        Map<String, Lookup> lookups = this.lookupsByArchetype.get(shortName);
        if (lookups == null) {
            lookups = new HashMap<String, Lookup>();
            Collection list = this.query(shortName);
            for (Lookup lookup : list) {
                String code = lookup.getCode();
                if (lookups.containsKey(code)) {
                    this.log.warn(messages.getMessage("DuplicateLookup", new Object[]{shortName, code}));
                    continue;
                }
                lookups.put(code, lookup);
                this.lookupsByRef.put(lookup.getObjectReference(), lookup);
            }
            this.lookupsByArchetype.put(shortName, lookups);
        }
        return lookups;
    }

    private RelatedLookups getTargets(Lookup lookup) {
        Reference ref = lookup.getObjectReference();
        return this.targetLookups.computeIfAbsent(ref, reference -> {
            Collection targets = CachingLookupService.super.getTargetLookups(lookup);
            return new RelatedLookups(targets);
        });
    }

    private String[] getShortNames(String shortName) {
        if (shortName.contains("*")) {
            return DescriptorHelper.getShortNames((String)shortName, (ArchetypeService)this.getService());
        }
        return new String[]{shortName};
    }

    private static class RelatedLookups {
        private final Set<Lookup> lookups;
        private final Map<String, Collection<Lookup>> lookupsByRelationship = new HashMap<String, Collection<Lookup>>();

        RelatedLookups(Collection<Lookup> lookups) {
            this.lookups = new HashSet<Lookup>(lookups);
        }

        public Collection<Lookup> getLookups() {
            return this.lookups;
        }

        public Collection<Lookup> getLookups(String relationship) {
            return this.lookupsByRelationship.get(relationship);
        }

        public void setLookups(String relationship, Collection<Lookup> lookups) {
            this.lookupsByRelationship.put(relationship, new ArrayList<Lookup>(lookups));
        }

        public void add(String relationship, Lookup lookup) {
            this.lookups.add(lookup);
            Collection<Lookup> lookups = this.lookupsByRelationship.get(relationship);
            if (lookups != null) {
                lookups.add(lookup);
            }
        }
    }
}

