/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.tools.doc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.PlatformTransactionManager;

@ContextConfiguration(value={"/applicationContext.xml"})
public abstract class AbstractLoaderTest
extends ArchetypeServiceTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    @Autowired
    protected PlatformTransactionManager transactionManager;

    AbstractLoaderTest() {
        super("archetypeService");
    }

    protected Set<File> getFiles(File dir) {
        return new HashSet<File>(FileUtils.listFiles((File)dir, null, (boolean)true));
    }

    protected File createFile(DocumentAct act, File dir) throws IOException {
        return this.createFile(act, dir, null);
    }

    protected File createFile(DocumentAct act, File dir, String prefix) throws IOException {
        return this.createFile(act, dir, prefix, null);
    }

    protected File createFile(DocumentAct act, File dir, String prefix, String suffix) throws IOException {
        return this.createFile(act, dir, prefix, suffix, null);
    }

    protected File createFile(DocumentAct act, File dir, String prefix, String suffix, String content) throws IOException {
        return this.createFile(act, dir, prefix, suffix, content, ".gif");
    }

    protected File createFile(DocumentAct act, File dir, String prefix, String suffix, String content, String extension) throws IOException {
        StringBuilder buff = new StringBuilder();
        if (prefix != null) {
            buff.append(prefix);
        }
        buff.append(act.getId());
        if (suffix != null) {
            buff.append(suffix);
        }
        buff.append(extension);
        return this.createFile(dir, buff.toString(), content);
    }

    protected File createFile(File dir, String name, String content) throws IOException {
        File file = new File(dir, name);
        if (content != null) {
            PrintStream stream = new PrintStream(new FileOutputStream(file));
            stream.print(content);
            stream.close();
        } else {
            FileUtils.touch((File)file);
        }
        return file;
    }

    protected DocumentAct createPatientDocAct() {
        return this.createPatientDocAct(null);
    }

    protected DocumentAct createPatientDocAct(String fileName) {
        return this.createPatientDocAct("act.patientDocumentAttachment", fileName);
    }

    protected DocumentAct createPatientDocAct(String shortName, String fileName) {
        Party patient = (Party)this.create("party.patientpet", Party.class);
        patient.setName("ZTestPet-" + System.currentTimeMillis());
        IMObjectBean bean = this.getBean((IMObject)patient);
        bean.setValue("species", (Object)"CANINE");
        this.save((IMObject)patient);
        DocumentAct act = (DocumentAct)this.create(shortName, DocumentAct.class);
        Assert.assertNotNull((Object)act);
        act.setFileName(fileName);
        IMObjectBean actBean = this.getBean((IMObject)act);
        actBean.setTarget("patient", (IMObject)patient);
        this.save((IMObject)act);
        return act;
    }

    protected void checkAct(DocumentAct act) {
        this.checkAct(act, act.getFileName());
    }

    protected Document checkAct(DocumentAct act, String name) {
        act = (DocumentAct)this.get((IMObject)act);
        Assert.assertNotNull((Object)act);
        Assert.assertNotNull((Object)act.getDocument());
        Document doc = (Document)this.get(act.getDocument());
        Assert.assertNotNull((Object)doc);
        Assert.assertEquals((Object)name, (Object)act.getFileName());
        Assert.assertEquals((Object)name, (Object)doc.getName());
        this.checkMimeType(act);
        return doc;
    }

    protected void checkNoDocument(DocumentAct act) {
        act = (DocumentAct)this.get((IMObject)act);
        Assert.assertNotNull((Object)act);
        Assert.assertNull((Object)act.getDocument());
    }

    protected void checkMimeType(DocumentAct act) {
        this.checkMimeType(act.getFileName(), act.getMimeType());
        Reference docRef = act.getDocument();
        if (docRef != null) {
            Document doc = (Document)this.get(docRef);
            Assert.assertNotNull((Object)doc);
            this.checkMimeType(doc.getName(), doc.getMimeType());
        }
    }

    protected void checkMimeType(String fileName, String mimeType) {
        if (fileName.endsWith(".gif")) {
            Assert.assertEquals((Object)"image/gif", (Object)mimeType);
        } else if (fileName.endsWith(".png")) {
            Assert.assertEquals((Object)"image/png", (Object)mimeType);
        } else if (fileName.endsWith(".pdf")) {
            Assert.assertEquals((Object)"application/pdf", (Object)mimeType);
        } else if (fileName.endsWith(".html") || fileName.endsWith(".htm")) {
            Assert.assertEquals((Object)"text/html", (Object)mimeType);
        } else if (fileName.endsWith(".txt")) {
            Assert.assertEquals((Object)"text/plain", (Object)mimeType);
        } else if (fileName.endsWith(".doc")) {
            Assert.assertEquals((Object)"application/msword", (Object)mimeType);
        } else if (fileName.endsWith(".odt")) {
            Assert.assertEquals((Object)"application/vnd.oasis.opendocument.text", (Object)mimeType);
        } else {
            Assert.fail((String)("Cannot determine if valid mime type for fileName: " + fileName));
        }
    }

    protected void checkFiles(File dir, File ... expected) {
        String[] names = new String[expected.length];
        for (int i = 0; i < expected.length; ++i) {
            names[i] = expected[i].getName();
        }
        Set<File> files = this.getFiles(dir);
        Assert.assertEquals((long)names.length, (long)files.size());
        List<String> list = Arrays.asList(names);
        for (File file : files) {
            Assert.assertTrue((boolean)list.contains(file.getName()));
        }
    }
}

