/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.tools.doc;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.etl.tools.doc.AbstractLoaderTest;
import org.openvpms.etl.tools.doc.DefaultDocumentFactory;
import org.openvpms.etl.tools.doc.DefaultLoadContext;
import org.openvpms.etl.tools.doc.DocumentFactory;
import org.openvpms.etl.tools.doc.DocumentLoader;
import org.openvpms.etl.tools.doc.FileStrategy;
import org.openvpms.etl.tools.doc.LoadContext;
import org.openvpms.etl.tools.doc.Loader;
import org.openvpms.etl.tools.doc.LoaderListener;
import org.openvpms.etl.tools.doc.LoggingLoaderListener;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class AbstractBasicLoaderTest
extends AbstractLoaderTest {
    @Test
    public void testMoveToErrorDir() throws Exception {
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        File error = this.folder.newFolder("edocs");
        File file = new File(source, System.nanoTime() + ".gif");
        FileUtils.touch((File)file);
        LoggingLoaderListener listener = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, error, false, false, (LoaderListener)listener);
        Assert.assertEquals((long)0L, (long)listener.getLoaded());
        Assert.assertEquals((long)1L, (long)listener.getErrors());
        Assert.assertEquals((long)1L, (long)listener.getProcessed());
        Assert.assertEquals((long)1L, (long)listener.getMissingAct());
        Assert.assertEquals((long)0L, (long)listener.getAlreadyLoaded());
        this.checkFiles(source, new File[0]);
        this.checkFiles(target, new File[0]);
        this.checkFiles(error, file);
    }

    @Test
    public void testFailToMoveToTarget() throws Exception {
        File source = this.folder.newFolder("sdocs");
        File target = new File(this.folder.getRoot(), "tdocs");
        File error = this.folder.newFolder("edocs");
        DocumentAct act = this.createPatientDocAct();
        File file = this.createSourceFile(act, source);
        LoggingLoaderListener listener = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, error, false, false, (LoaderListener)listener);
        this.checkFiles(source, new File[0]);
        this.checkFiles(error, file);
        Assert.assertEquals((long)0L, (long)listener.getLoaded());
        Assert.assertEquals((long)1L, (long)listener.getProcessed());
        Assert.assertEquals((long)1L, (long)listener.getErrors());
        act = (DocumentAct)this.get((IMObject)act);
        this.checkAct(act, file.getName());
    }

    @Test
    public void testFailToMoveToError() throws Exception {
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        File error = new File(this.folder.getRoot(), "edocs");
        File file = new File(source, System.nanoTime() + ".gif");
        FileUtils.touch((File)file);
        LoggingLoaderListener listener = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, error, false, false, (LoaderListener)listener);
        Assert.assertEquals((long)0L, (long)listener.getLoaded());
        Assert.assertEquals((long)1L, (long)listener.getErrors());
        Assert.assertEquals((long)1L, (long)listener.getProcessed());
        Assert.assertEquals((long)0L, (long)listener.getMissingAct());
        Assert.assertEquals((long)0L, (long)listener.getAlreadyLoaded());
        this.checkFiles(source, file);
        this.checkFiles(target, new File[0]);
    }

    @Test
    public void testDuplicateFileInTargetNoRename() throws Exception {
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        File error = this.folder.newFolder("edocs");
        DocumentAct act = this.createPatientDocAct();
        File file = this.createSourceFile(act, source);
        File fileWithSameName = this.createFile(target, file.getName(), "some random content");
        LoggingLoaderListener listener = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, error, false, false, (LoaderListener)listener);
        this.checkFiles(source, new File[0]);
        this.checkFiles(target, fileWithSameName);
        this.checkFiles(error, file);
        Assert.assertEquals((long)0L, (long)listener.getLoaded());
        Assert.assertEquals((long)1L, (long)listener.getProcessed());
        Assert.assertEquals((long)1L, (long)listener.getErrors());
        act = (DocumentAct)this.get((IMObject)act);
        this.checkAct(act, file.getName());
    }

    @Test
    public void testDuplicateFileInTargetWithRename() throws Exception {
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        File error = this.folder.newFolder("edocs");
        DocumentAct act = this.createPatientDocAct();
        File file = this.createSourceFile(act, source);
        File fileWithSameName = this.createFile(target, file.getName(), "random content");
        LoggingLoaderListener listener = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, error, false, true, (LoaderListener)listener);
        this.checkFiles(source, new File[0]);
        this.checkFiles(error, new File[0]);
        Set<File> files = this.getFiles(target);
        Assert.assertEquals((long)2L, (long)files.size());
        Assert.assertTrue((boolean)files.remove(fileWithSameName));
        File renamed = files.iterator().next();
        this.checkFiles(target, fileWithSameName, renamed);
        Assert.assertEquals((long)1L, (long)listener.getLoaded());
        Assert.assertEquals((long)1L, (long)listener.getProcessed());
        Assert.assertEquals((long)0L, (long)listener.getErrors());
        act = (DocumentAct)this.get((IMObject)act);
        Assert.assertNotNull((Object)act.getDocument());
    }

    @Test
    public void testDuplicateFileInErrorNoRename() throws Exception {
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        File error = this.folder.newFolder("edocs");
        File file = this.createFile(source, "" + System.nanoTime() + ".gif", "some random content");
        File fileWithSameName = this.createFile(error, file.getName(), "some more random content");
        LoggingLoaderListener listener = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, error, false, false, (LoaderListener)listener);
        this.checkFiles(source, file);
        this.checkFiles(target, new File[0]);
        this.checkFiles(error, fileWithSameName);
        Assert.assertEquals((long)0L, (long)listener.getLoaded());
        Assert.assertEquals((long)1L, (long)listener.getProcessed());
        Assert.assertEquals((long)1L, (long)listener.getErrors());
    }

    @Test
    public void testDuplicateFileInErrorWithRename() throws Exception {
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        File error = this.folder.newFolder("edocs");
        File file = this.createFile(source, "" + System.nanoTime() + ".gif", "some random content");
        File fileWithSameName = this.createFile(error, file.getName(), "some more random content");
        LoggingLoaderListener listener = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, error, false, true, (LoaderListener)listener);
        this.checkFiles(source, new File[0]);
        this.checkFiles(target, new File[0]);
        Set<File> files = this.getFiles(error);
        Assert.assertEquals((long)2L, (long)files.size());
        Assert.assertTrue((boolean)files.remove(fileWithSameName));
        File renamed = files.iterator().next();
        this.checkFiles(error, fileWithSameName, renamed);
        Assert.assertEquals((long)0L, (long)listener.getLoaded());
        Assert.assertEquals((long)1L, (long)listener.getProcessed());
        Assert.assertEquals((long)1L, (long)listener.getErrors());
    }

    protected void load(File source, File target, File error, boolean overwrite, boolean rename, LoaderListener listener) {
        this.load(source, null, target, error, overwrite, rename, listener);
    }

    protected void load(File source, String shortName, File target, File error, boolean overwrite, boolean rename, LoaderListener listener) {
        String[] stringArray;
        if (shortName != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = shortName;
        } else {
            stringArray = null;
        }
        String[] shortNames = stringArray;
        FileStrategy strategy = new FileStrategy(target, error, rename);
        DefaultLoadContext context = new DefaultLoadContext(strategy, listener);
        Loader loader = this.createLoader(source, shortNames, this.getArchetypeService(), (DocumentFactory)new DefaultDocumentFactory(this.getArchetypeService()), this.transactionManager, overwrite, (LoadContext)context);
        this.load(loader, listener);
    }

    protected abstract File createSourceFile(DocumentAct var1, File var2) throws IOException;

    protected abstract Loader createLoader(File var1, String[] var2, IArchetypeService var3, DocumentFactory var4, PlatformTransactionManager var5, boolean var6, LoadContext var7);

    protected void checkVersions(DocumentAct act, Document ... versions) {
        act = (DocumentAct)this.get((IMObject)act);
        IMObjectBean bean = this.getBean((IMObject)act);
        List acts = bean.getTargets("versions", DocumentAct.class);
        Assert.assertEquals((long)versions.length, (long)acts.size());
        for (DocumentAct childAct : acts) {
            this.checkAct(childAct);
            boolean found = false;
            for (Document version : versions) {
                if (!childAct.getDocument().equals((Object)version.getObjectReference())) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found);
        }
    }

    protected void load(Loader loader, LoaderListener listener) {
        DocumentLoader docLoader = new DocumentLoader(loader, listener);
        docLoader.setFailOnError(false);
        docLoader.load();
    }
}

