/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.tools.doc;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.etl.tools.doc.AbstractLoader;
import org.openvpms.etl.tools.doc.DefaultDocumentFactory;
import org.openvpms.etl.tools.doc.DocumentFactory;
import org.openvpms.etl.tools.doc.LoadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class IdLoader
extends AbstractLoader {
    public static final String DEFAULT_REGEXP = "[^\\d]*(\\d+).*";
    private final Pattern pattern;
    private final LoadContext context;
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("[^\\d]*(\\d+).*");
    private static final Logger log = LoggerFactory.getLogger(IdLoader.class);

    public IdLoader(File dir, String[] shortNames, IArchetypeService service, DocumentFactory factory, PlatformTransactionManager transactionManager, boolean recurse, boolean overwrite, LoadContext context) {
        this(dir, shortNames, service, factory, transactionManager, recurse, overwrite, DEFAULT_PATTERN, context);
    }

    public IdLoader(File dir, String[] shortNames, IArchetypeService service, PlatformTransactionManager transactionManager, boolean recurse, boolean overwrite, Pattern pattern, LoadContext context) {
        this(dir, shortNames, service, new DefaultDocumentFactory(service), transactionManager, recurse, overwrite, pattern, context);
    }

    public IdLoader(File dir, String[] shortNames, IArchetypeService service, DocumentFactory factory, PlatformTransactionManager transactionManager, boolean recurse, boolean overwrite, Pattern pattern, LoadContext context) {
        super(dir, shortNames, service, factory, transactionManager, recurse, overwrite);
        this.pattern = pattern;
        this.context = context;
        log.debug("pattern={}", (Object)pattern);
    }

    @Override
    protected boolean load(File file, boolean overwrite) {
        DocumentAct act;
        boolean result = false;
        long id = this.getId(file.getName());
        DocumentAct documentAct = act = id != -1L ? this.getAct(id) : null;
        if (act != null) {
            result = this.load(act, file, overwrite, this.context);
        } else {
            this.context.missingAct(file, id);
        }
        return result;
    }

    protected DocumentAct getAct(long id) {
        return this.getAct(id, this.getShortNames());
    }

    private long getId(String name) {
        long result = -1L;
        Matcher matcher = this.pattern.matcher(name);
        if (matcher.matches()) {
            result = Long.parseLong(matcher.group(1));
            log.debug("match: {}, id={}", (Object)name, (Object)result);
        } else {
            log.debug("no match: {}", (Object)name);
        }
        return result;
    }
}

