/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.tools.doc;

import java.io.File;
import java.io.IOException;
import org.openvpms.etl.tools.doc.FileStrategy;
import org.openvpms.etl.tools.doc.LoadContext;
import org.openvpms.etl.tools.doc.LoaderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLoadContext
implements LoadContext {
    private final FileStrategy strategy;
    private final LoaderListener listener;
    private static final Logger log = LoggerFactory.getLogger(DefaultLoadContext.class);

    public DefaultLoadContext(FileStrategy strategy, LoaderListener listener) {
        this.strategy = strategy;
        this.listener = listener;
    }

    public LoaderListener getListener() {
        return this.listener;
    }

    @Override
    public boolean loaded(File file, long id) {
        boolean result = false;
        try {
            File target = this.strategy.loaded(file);
            result = true;
            this.notifyLoaded(file, id, target);
        }
        catch (IOException exception) {
            log.warn("File {} was loaded, but could not be moved to the target directory. Attempting to move it to the error directory.", (Object)file, (Object)exception);
            try {
                File target = this.strategy.error(file);
                this.notifyError(file, exception, target);
            }
            catch (IOException nested) {
                log.warn("File {} was loaded, and could not be moved to the target or error directory. ", (Object)file, (Object)nested);
                this.notifyError(file, exception, file);
            }
        }
        return result;
    }

    @Override
    public void alreadyLoaded(File file, long id) {
        try {
            File target = this.strategy.error(file);
            this.notifyAlreadyLoaded(file, id, target);
        }
        catch (IOException exception) {
            log.warn("File {} already loaded, but cannot be moved to the error directory", (Object)file);
            this.notifyError(file, exception, file);
        }
    }

    @Override
    public void missingAct(File file) {
        try {
            File target = this.strategy.error(file);
            this.notifyMissingAct(file, target);
        }
        catch (IOException exception) {
            log.warn("File {} missing act but cannot be moved to the error directory", (Object)file);
            this.notifyError(file, exception, file);
        }
    }

    @Override
    public void missingAct(File file, long id) {
        try {
            File target = this.strategy.error(file);
            this.notifyMissingAct(file, id, target);
        }
        catch (IOException exception) {
            log.warn("File {} missing act: {} but cannot be moved to the error directory", (Object)file, (Object)id);
            this.notifyError(file, exception, file);
        }
    }

    @Override
    public void error(File file, Throwable error) {
        try {
            if (file.exists()) {
                File target = this.strategy.error(file);
                this.notifyError(file, error, target);
            } else {
                this.notifyError(file, error, file);
            }
        }
        catch (IOException nested) {
            log.warn("Failed to move {} to the error directory", (Object)file, (Object)nested);
            this.notifyError(file, error, file);
        }
    }

    @Override
    public void error(File file, String message) {
        try {
            if (file.exists()) {
                File target = this.strategy.error(file);
                this.notifyError(file, message, target);
            } else {
                this.notifyError(file, message, file);
            }
        }
        catch (IOException nested) {
            log.warn("Failed to move {} to the error directory", (Object)file, (Object)nested);
            this.notifyError(file, message, file);
        }
    }

    protected void notifyLoaded(File file, long id, File target) {
        if (this.listener != null) {
            this.listener.loaded(file, id, target);
        }
    }

    protected void notifyAlreadyLoaded(File file, long id, File target) {
        if (this.listener != null) {
            this.listener.alreadyLoaded(file, id, target);
        }
    }

    protected void notifyMissingAct(File file, File target) {
        if (this.listener != null) {
            this.listener.missingAct(file, target);
        }
    }

    protected void notifyMissingAct(File file, long id, File target) {
        if (this.listener != null) {
            this.listener.missingAct(file, id, target);
        }
    }

    protected void notifyError(File file, Throwable error, File target) {
        if (this.listener != null) {
            this.listener.error(file, error, target);
        }
    }

    protected void notifyError(File file, String message, File target) {
        if (this.listener != null) {
            this.listener.error(file, message, target);
        }
    }
}

