/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.load;

public class SymbolicReference {
    private final String archetype;
    private final String rowId;
    private final String name;
    private final String value;

    public SymbolicReference(String archetype, String legacyId) {
        this.archetype = archetype;
        this.rowId = legacyId;
        this.name = null;
        this.value = null;
    }

    public SymbolicReference(String archetype, String name, String value) {
        this.archetype = archetype;
        this.rowId = null;
        this.name = name;
        this.value = value;
    }

    public String getArchetype() {
        return this.archetype;
    }

    public String getRowId() {
        return this.rowId;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        String result = this.rowId != null ? SymbolicReference.create(this.archetype, this.rowId) : SymbolicReference.create(this.archetype, this.name, this.value);
        return result;
    }

    public static String create(String archetype, String rowId) {
        return "<" + archetype + ">" + rowId;
    }

    public static String create(String archetype, String name, String value) {
        return "<" + archetype + ">" + name + "=" + value;
    }
}

