/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.load;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.archetype.AssertionDescriptor;
import org.openvpms.component.model.archetype.NamedProperty;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.lookup.LookupRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.etl.load.ErrorListener;
import org.openvpms.etl.load.ExceptionHelper;
import org.openvpms.etl.load.LoaderException;
import org.openvpms.etl.load.LookupCache;
import org.openvpms.etl.load.LookupData;
import org.openvpms.etl.load.LookupDescriptor;
import org.openvpms.etl.load.LookupRelationshipDescriptor;
import org.openvpms.etl.load.Mapping;
import org.openvpms.etl.load.Mappings;
import org.openvpms.etl.load.Node;
import org.openvpms.etl.load.NodeParser;
import org.openvpms.etl.load.Pair;

class LookupHandler {
    private final Map<NodeDescriptor, LookupDescriptor> lookups = new HashMap<NodeDescriptor, LookupDescriptor>();
    private final Map<NodeDescriptor, LookupRelationshipDescriptor> relationships = new HashMap<NodeDescriptor, LookupRelationshipDescriptor>();
    private final IArchetypeService service;
    private final ExceptionHelper messages;
    private final LookupCache cache;
    private ErrorListener listener;
    private static final String LOOKUP = "lookup";

    public LookupHandler(Mappings mappings, IArchetypeService service, LookupService lookups) {
        this.service = service;
        this.cache = new LookupCache(service, lookups);
        this.messages = new ExceptionHelper(service);
        HashMap<NodeDescriptor, ArchetypeDescriptor> targets = new HashMap<NodeDescriptor, ArchetypeDescriptor>();
        for (Mapping mapping : mappings.getMapping()) {
            String target = mapping.getTarget();
            for (Node node = NodeParser.parse(target); node != null; node = node.getChild()) {
                this.processNode(node, targets);
            }
        }
        for (Map.Entry entry : targets.entrySet()) {
            this.processTargetLookupDescriptor((ArchetypeDescriptor)entry.getValue(), (NodeDescriptor)entry.getKey());
        }
    }

    public boolean isGeneratedLookup(NodeDescriptor descriptor) {
        return this.lookups.containsKey(descriptor);
    }

    public void add(Map<NodeDescriptor, LookupData> descriptors) {
        for (Map.Entry<NodeDescriptor, LookupData> entry : descriptors.entrySet()) {
            LookupData source;
            NodeDescriptor descriptor = entry.getKey();
            LookupData data = entry.getValue();
            LookupDescriptor lookup = this.lookups.get(descriptor);
            lookup.add(data);
            LookupRelationshipDescriptor relationship = this.relationships.get(descriptor);
            if (relationship == null || (source = descriptors.get(relationship.getSource().getDescriptor())) == null) continue;
            relationship.add(source.getCode(), data.getCode());
        }
    }

    public String getCode(String name) {
        String result = null;
        if (name != null) {
            result = name.toUpperCase();
            result = result.replaceAll("[^A-Z0-9]+", "_");
        }
        return result;
    }

    public void setErrorListener(ErrorListener listener) {
        this.listener = listener;
    }

    public void commit() {
        if (!this.lookups.isEmpty()) {
            this.saveLookups();
        }
        if (!this.relationships.isEmpty()) {
            this.saveRelationships();
        }
    }

    public void close() {
        this.lookups.clear();
        this.relationships.clear();
    }

    protected void save(Collection<IMObject> objects) {
        try {
            this.service.save(objects);
        }
        catch (OpenVPMSException exception) {
            for (IMObject object : objects) {
                this.save(object);
            }
        }
    }

    protected void save(IMObject object) {
        try {
            this.service.save(object);
        }
        catch (OpenVPMSException exception) {
            this.notifyListener(exception);
        }
    }

    protected boolean exists(String archetype, String code) {
        return this.cache.exists(archetype, code);
    }

    protected boolean exists(String archetype, Lookup source, Lookup target) {
        return this.cache.exists(archetype, source.getObjectReference(), target.getObjectReference());
    }

    private void saveLookups() {
        ArrayList<IMObject> objects = new ArrayList<IMObject>();
        for (LookupDescriptor descriptor : this.lookups.values()) {
            for (LookupData data : descriptor.getLookups()) {
                if (this.exists(descriptor.getArchetype(), data.getCode())) continue;
                this.createLookup(data, descriptor, objects);
            }
            descriptor.clear();
        }
        if (!objects.isEmpty()) {
            this.save(objects);
        }
    }

    private void saveRelationships() {
        for (LookupRelationshipDescriptor descriptor : this.relationships.values()) {
            List<IMObject> objects = this.createRelationships(descriptor);
            if (!objects.isEmpty()) {
                this.save(objects);
            }
            descriptor.clear();
        }
    }

    private void createLookup(LookupData data, LookupDescriptor descriptor, List<IMObject> objects) {
        String archetype = data.getArchetype();
        if (archetype == null) {
            archetype = descriptor.getArchetype();
        }
        Lookup lookup = (Lookup)this.service.create(archetype, Lookup.class);
        lookup.setCode(data.getCode());
        lookup.setName(data.getName());
        objects.add((IMObject)lookup);
        this.cache.add(lookup);
    }

    private void processNode(Node node, Map<NodeDescriptor, ArchetypeDescriptor> targets) {
        NodeDescriptor descriptor;
        ArchetypeDescriptor archetype = this.service.getArchetypeDescriptor(node.getArchetype());
        if (archetype != null && (descriptor = archetype.getNodeDescriptor(node.getName())) != null && descriptor.isLookup()) {
            if (this.isLookupType(descriptor)) {
                this.processLookupDescriptor(descriptor);
            }
            if (this.isTargetLookupType(descriptor)) {
                targets.put(descriptor, archetype);
            }
        }
    }

    private void processLookupDescriptor(NodeDescriptor descriptor) {
        AssertionDescriptor assertion = descriptor.getAssertionDescriptor(LOOKUP);
        String archetype = this.getValue(assertion, "source");
        this.lookups.put(descriptor, new LookupDescriptor(descriptor, archetype));
    }

    private void processTargetLookupDescriptor(ArchetypeDescriptor archetype, NodeDescriptor target) {
        AssertionDescriptor assertion = target.getAssertionDescriptor(LOOKUP);
        String relationship = this.getValue(assertion, "relationship");
        if (relationship == null) {
            throw new LoaderException(LoaderException.ErrorCode.LookupRelationshipNotFound, archetype.getArchetypeType(), target.getName());
        }
        String value = this.getValue(assertion, "value");
        NodeDescriptor source = this.getNodeByPath(archetype, value);
        if (source == null) {
            String shortName = archetype.getType().getShortName();
            throw new LoaderException(LoaderException.ErrorCode.LookupSourceNodeNotFound, shortName, target.getName(), value);
        }
        String targetShortName = this.getTargetShortName(relationship);
        LookupDescriptor targetLookup = new LookupDescriptor(target, targetShortName);
        this.lookups.put(target, targetLookup);
        LookupDescriptor sourceLookup = this.lookups.get(source);
        if (sourceLookup != null) {
            LookupRelationshipDescriptor descriptor = new LookupRelationshipDescriptor(relationship, sourceLookup, targetLookup);
            this.relationships.put(target, descriptor);
        }
    }

    private String getTargetShortName(String relationship) {
        String[] shortNames;
        ArchetypeDescriptor archetype = this.service.getArchetypeDescriptor(relationship);
        if (archetype == null) {
            throw new LoaderException(LoaderException.ErrorCode.ArchetypeNotFound, relationship);
        }
        NodeDescriptor node = archetype.getNodeDescriptor("target");
        String result = null;
        if (node != null && (shortNames = DescriptorHelper.getShortNames((org.openvpms.component.model.archetype.NodeDescriptor)node, (ArchetypeService)this.service)).length > 0) {
            result = shortNames[0];
        }
        if (result == null) {
            throw new LoaderException(LoaderException.ErrorCode.LookupRelationshipTargetNotFound, relationship);
        }
        return result;
    }

    private List<IMObject> createRelationships(LookupRelationshipDescriptor descriptor) {
        ArrayList<IMObject> result = new ArrayList<IMObject>();
        for (Pair pair : descriptor.getPairs()) {
            String sourceCode = pair.getValue1();
            String targetCode = pair.getValue2();
            Lookup source = this.getLookup(descriptor.getSource(), sourceCode);
            Lookup target = this.getLookup(descriptor.getTarget(), targetCode);
            if (source != null && target != null) {
                if (this.exists(descriptor.getArchetype(), source, target)) continue;
                org.openvpms.component.business.domain.im.lookup.LookupRelationship relationship = (org.openvpms.component.business.domain.im.lookup.LookupRelationship)this.service.create(descriptor.getArchetype(), org.openvpms.component.business.domain.im.lookup.LookupRelationship.class);
                relationship.setSource(source.getObjectReference());
                relationship.setTarget(target.getObjectReference());
                result.add((IMObject)relationship);
                this.cache.add((LookupRelationship)relationship);
                continue;
            }
            if (source == null) {
                throw new LoaderException(LoaderException.ErrorCode.LookupNotFound, descriptor.getSource().getArchetype(), sourceCode);
            }
            throw new LoaderException(LoaderException.ErrorCode.LookupNotFound, descriptor.getTarget().getArchetype(), targetCode);
        }
        return result;
    }

    private Lookup getLookup(LookupDescriptor descriptor, String code) {
        return this.cache.get(descriptor.getArchetype(), code);
    }

    private NodeDescriptor getNodeByPath(ArchetypeDescriptor archetype, String path) {
        for (NodeDescriptor node : archetype.getAllNodeDescriptors()) {
            if (!node.getPath().equals(path)) continue;
            return node;
        }
        return null;
    }

    private boolean isLookupType(NodeDescriptor descriptor) {
        AssertionDescriptor assertion = descriptor.getAssertionDescriptor(LOOKUP);
        if (assertion != null) {
            String type = this.getValue(assertion, "type");
            return LOOKUP.equals(type);
        }
        return false;
    }

    private boolean isTargetLookupType(NodeDescriptor descriptor) {
        AssertionDescriptor assertion = descriptor.getAssertionDescriptor(LOOKUP);
        if (assertion != null) {
            String type = this.getValue(assertion, "type");
            return "targetLookup".equals(type);
        }
        return false;
    }

    private String getValue(AssertionDescriptor assertion, String name) {
        NamedProperty property = assertion.getProperty(name);
        return property != null ? (String)property.getValue() : null;
    }

    private void notifyListener(Throwable exception) {
        if (this.listener != null) {
            this.listener.error(this.messages.getMessage(exception), exception);
        }
    }
}

