/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.load;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.lookup.LookupRelationship;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.etl.load.CachingLookupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LookupCache {
    private final IArchetypeService service;
    private final LookupService lookupService;
    private final Map<String, List<LookupRelationship>> relationshipsByArchetype = new HashMap<String, List<LookupRelationship>>();
    private static final Logger log = LoggerFactory.getLogger(LookupCache.class);

    public LookupCache(IArchetypeService service, LookupService lookupService) {
        this.service = service;
        this.lookupService = lookupService;
        if (!(lookupService instanceof CachingLookupService)) {
            log.warn("{} is not configured. The lookup cache may not perform optimally", (Object)CachingLookupService.class.getName());
        }
    }

    public Lookup get(String archetype, String code) {
        return this.lookupService.getLookup(archetype, code);
    }

    public void add(Lookup lookup) {
        if (this.lookupService instanceof CachingLookupService) {
            ((CachingLookupService)this.lookupService).add(lookup);
        }
    }

    public boolean exists(String archetype, String code) {
        return this.get(archetype, code) != null;
    }

    public void add(LookupRelationship relationship) {
        String archetype = relationship.getArchetype();
        List<LookupRelationship> relationships = this.getRelationships(archetype);
        relationships.add(relationship);
        if (this.lookupService instanceof CachingLookupService) {
            CachingLookupService cache = (CachingLookupService)this.lookupService;
            cache.add(relationship);
        }
    }

    public boolean exists(String archetype, Reference source, Reference target) {
        for (LookupRelationship relationship : this.getRelationships(archetype)) {
            if (!Objects.equals(relationship.getSource(), source) || !Objects.equals(relationship.getTarget(), target)) continue;
            return true;
        }
        return false;
    }

    private List<LookupRelationship> getRelationships(String archetype) {
        List<LookupRelationship> relationships = this.relationshipsByArchetype.get(archetype);
        if (relationships == null) {
            relationships = new ArrayList<LookupRelationship>();
            ArchetypeQuery query = new ArchetypeQuery(archetype, false, true);
            query.setMaxResults(-1);
            IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
            while (iterator.hasNext()) {
                relationships.add((LookupRelationship)iterator.next());
            }
            this.relationshipsByArchetype.put(archetype, relationships);
        }
        return relationships;
    }
}

