/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.load;

import java.util.Collections;
import java.util.List;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.etl.load.DefaultObjectHandler;
import org.openvpms.etl.load.ETLLogDAO;
import org.openvpms.etl.load.ETLRow;
import org.openvpms.etl.load.ErrorListener;
import org.openvpms.etl.load.LookupHandler;
import org.openvpms.etl.load.Mappings;
import org.openvpms.etl.load.ObjectHandler;
import org.openvpms.etl.load.RowMapper;

public class Loader {
    private final String name;
    private final ETLLogDAO dao;
    private final ObjectHandler handler;
    private final RowMapper mapper;
    private final LookupHandler lookupHandler;
    private final boolean skipProcessed;

    public Loader(String name, Mappings mappings, ETLLogDAO dao, IArchetypeService service, LookupService lookups) {
        this(name, mappings, dao, service, lookups, new DefaultObjectHandler(name, mappings, dao, service));
    }

    protected Loader(String name, Mappings mappings, ETLLogDAO dao, IArchetypeService service, LookupService lookups, ObjectHandler handler) {
        this.name = name;
        this.dao = dao;
        this.handler = handler;
        this.lookupHandler = new LookupHandler(mappings, service, lookups);
        this.mapper = new RowMapper(mappings, handler, this.lookupHandler, service);
        this.skipProcessed = mappings.getSkipProcessed();
    }

    public List<IMObject> load(ETLRow row) {
        List<IMObject> objects = Collections.emptyList();
        if (!this.skipProcessed || !this.dao.processed(this.name, row.getRowId())) {
            try {
                objects = this.mapper.map(row);
                if (this.lookupHandler != null) {
                    this.lookupHandler.commit();
                }
                this.handler.commit();
            }
            catch (OpenVPMSException exception) {
                this.handler.rollback();
                this.handler.error(row.getRowId(), exception);
            }
        }
        return objects;
    }

    public void setErrorListener(ErrorListener listener) {
        this.handler.setErrorListener(listener);
    }

    public void close() {
        if (this.lookupHandler != null) {
            this.lookupHandler.commit();
            this.lookupHandler.close();
        }
        this.handler.end();
        this.handler.close();
    }
}

