/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.load;

import java.util.List;
import org.apache.commons.resources.Messages;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.ValidationException;
import org.openvpms.component.service.archetype.ValidationError;

public class ExceptionHelper {
    private final IArchetypeService service;
    private static final Messages messages = Messages.getMessages((String)"org.openvpms.etl.load.messages");

    public ExceptionHelper(IArchetypeService service) {
        this.service = service;
    }

    public String getMessage(Throwable exception) {
        Throwable cause = this.getRootCause(exception);
        String message = cause instanceof ValidationException ? this.getMessage((ValidationException)cause) : cause.getLocalizedMessage();
        if (message == null) {
            message = cause.toString();
        }
        return message;
    }

    public Throwable getRootCause(Throwable exception) {
        if (exception.getCause() != null) {
            return this.getRootCause(exception.getCause());
        }
        return exception;
    }

    private String getMessage(ValidationException exception) {
        List errors = exception.getErrors();
        if (!errors.isEmpty()) {
            ValidationError error = (ValidationError)errors.get(0);
            return this.getError(error);
        }
        return exception.getLocalizedMessage();
    }

    private String getError(ValidationError error) {
        String archetypeName = null;
        String nodeName = null;
        ArchetypeDescriptor archetype = this.service.getArchetypeDescriptor(error.getArchetype());
        if (archetype != null) {
            archetypeName = archetype.getDisplayName();
            NodeDescriptor descriptor = archetype.getNodeDescriptor(error.getNode());
            if (descriptor != null) {
                nodeName = descriptor.getDisplayName();
            }
        }
        return messages.getMessage("ValidationError", new Object[]{archetypeName, nodeName, error.getMessage()});
    }
}

