/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.tools.doc;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentHelper;
import org.openvpms.archetype.rules.laboratory.LaboratoryTestHelper;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.AuditableIMObject;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.etl.tools.doc.AbstractBasicLoaderTest;
import org.openvpms.etl.tools.doc.DefaultDocumentFactory;
import org.openvpms.etl.tools.doc.DefaultLoadContext;
import org.openvpms.etl.tools.doc.DocumentFactory;
import org.openvpms.etl.tools.doc.DocumentLoader;
import org.openvpms.etl.tools.doc.FileStrategy;
import org.openvpms.etl.tools.doc.IdLoader;
import org.openvpms.etl.tools.doc.LoadContext;
import org.openvpms.etl.tools.doc.Loader;
import org.openvpms.etl.tools.doc.LoaderListener;
import org.openvpms.etl.tools.doc.LoggingLoaderListener;
import org.springframework.transaction.PlatformTransactionManager;

public class IdLoaderTestCase
extends AbstractBasicLoaderTest {
    @Test
    public void testLoad() throws Exception {
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        DocumentAct act1 = this.createPatientDocAct("file1.gif");
        DocumentAct act2 = this.createPatientDocAct("file2.pdf");
        DocumentAct act3 = this.createPatientDocAct("file3.html");
        DocumentAct act4 = this.createPatientDocAct("file4.png");
        DocumentAct act5 = this.createPatientDocAct("file5.hml");
        File act1File = this.createFile(act1, source, null, null, ".gif");
        File act2File = this.createFile(act2, source, "V", null, ".pdf");
        File act3File = this.createFile(act3, source, null, "-12345", null, ".html");
        File act4File = this.createFile(act4, source, "P", "-123456", null, ".png");
        File act5File = this.createFile(act5, source, "P", "-123457", null, ".htm");
        LoggingLoaderListener listener = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, null, false, false, (LoaderListener)listener);
        Assert.assertEquals((long)5L, (long)listener.getLoaded());
        Assert.assertEquals((long)0L, (long)listener.getErrors());
        Assert.assertEquals((long)5L, (long)listener.getProcessed());
        Assert.assertEquals((long)0L, (long)listener.getMissingAct());
        Assert.assertEquals((long)0L, (long)listener.getAlreadyLoaded());
        Set<File> files = this.getFiles(source);
        Assert.assertEquals((long)0L, (long)files.size());
        this.checkFiles(target, act1File, act2File, act3File, act4File, act5File);
        this.checkAct(act1, act1File.getName());
        this.checkAct(act2, act2File.getName());
        this.checkAct(act3, act3File.getName());
        this.checkAct(act4, act4File.getName());
        this.checkAct(act5, act5File.getName());
    }

    @Test
    public void testMissingAct() throws Exception {
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        File noAct1 = new File(source, "0000.gif");
        FileUtils.touch((File)noAct1);
        File noAct2 = new File(source, "C987654321.gif");
        FileUtils.touch((File)noAct2);
        File noAct3 = new File(source, "0000-12345.gif");
        FileUtils.touch((File)noAct3);
        LoggingLoaderListener listener = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, null, false, false, (LoaderListener)listener);
        int expectedErrors = 3;
        Assert.assertEquals((long)0L, (long)listener.getLoaded());
        Assert.assertEquals((long)expectedErrors, (long)listener.getErrors());
        Assert.assertEquals((long)expectedErrors, (long)listener.getProcessed());
        Assert.assertEquals((long)expectedErrors, (long)listener.getMissingAct());
        Assert.assertEquals((long)0L, (long)listener.getAlreadyLoaded());
        this.checkFiles(source, noAct1, noAct2, noAct3);
        this.checkFiles(target, new File[0]);
    }

    @Test
    public void testSkipProcessed() throws Exception {
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        DocumentAct preLoaded = this.createPatientDocAct();
        File preloadedFile = this.createFile(preLoaded, source, null);
        Document doc = DocumentHelper.create((File)preloadedFile, (String)"image/gif", (DocumentHandlers)new DocumentHandlers((ArchetypeService)this.getArchetypeService()));
        preLoaded.setDocument((Reference)doc.getObjectReference());
        preLoaded.setFileName(doc.getName());
        this.save((IMObject[])new AuditableIMObject[]{doc, preLoaded});
        LoggingLoaderListener listener = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, null, false, false, (LoaderListener)listener);
        Assert.assertEquals((long)0L, (long)listener.getLoaded());
        Assert.assertEquals((long)1L, (long)listener.getErrors());
        Assert.assertEquals((long)1L, (long)listener.getProcessed());
        Assert.assertEquals((long)0L, (long)listener.getMissingAct());
        Assert.assertEquals((long)1L, (long)listener.getAlreadyLoaded());
        this.checkFiles(source, preloadedFile);
        this.checkFiles(target, new File[0]);
    }

    @Test
    public void testTimestampOrdering() throws Exception {
        int count = 3;
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        DocumentAct act = this.createPatientDocAct();
        File first = this.createFile(act, source, null, "-Z");
        File second = this.createFile(act, source, null, "-A");
        File third = this.createFile(act, source, null, "-X");
        Assert.assertTrue((boolean)second.setLastModified(first.lastModified() + 1000L));
        Assert.assertTrue((boolean)third.setLastModified(second.lastModified() + 1000L));
        LoggingLoaderListener listener1 = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, null, false, false, (LoaderListener)listener1);
        Assert.assertEquals((long)1L, (long)listener1.getLoaded());
        Assert.assertEquals((long)2L, (long)listener1.getErrors());
        Assert.assertEquals((long)3L, (long)listener1.getProcessed());
        Assert.assertEquals((long)0L, (long)listener1.getMissingAct());
        Assert.assertEquals((long)2L, (long)listener1.getAlreadyLoaded());
        this.checkFiles(target, first);
        this.checkFiles(source, second, third);
        LoggingLoaderListener listener2 = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, null, true, false, (LoaderListener)listener2);
        Assert.assertEquals((long)2L, (long)listener2.getLoaded());
        Assert.assertEquals((long)0L, (long)listener2.getErrors());
        Assert.assertEquals((long)2L, (long)listener2.getProcessed());
        Assert.assertEquals((long)0L, (long)listener2.getMissingAct());
        Assert.assertEquals((long)0L, (long)listener2.getAlreadyLoaded());
        this.checkFiles(source, new File[0]);
        this.checkFiles(target, first, second, third);
        act = (DocumentAct)this.get((IMObject)act);
        this.checkAct(act, third.getName());
        IMObjectBean bean = this.getBean((IMObject)act);
        List versions = bean.getTargets("versions", DocumentAct.class);
        Assert.assertEquals((long)2L, (long)versions.size());
        DocumentAct firstVersion = this.getVersion(versions, first.getName());
        Assert.assertNotNull((Object)firstVersion);
        DocumentAct secondVersion = this.getVersion(versions, second.getName());
        Assert.assertNotNull((Object)secondVersion);
        this.checkAct(firstVersion, first.getName());
        this.checkAct(secondVersion, second.getName());
    }

    @Test
    public void testDuplicates() throws Exception {
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        DocumentAct act = this.createPatientDocAct();
        int alreadyLoaded = 0;
        File first = this.createFile(act, source, null, "-Z", "A");
        LoggingLoaderListener listener1 = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, null, true, false, (LoaderListener)listener1);
        Assert.assertEquals((long)1L, (long)listener1.getLoaded());
        Assert.assertEquals((long)0L, (long)listener1.getErrors());
        Assert.assertEquals((long)1L, (long)listener1.getProcessed());
        Assert.assertEquals((long)0L, (long)listener1.getMissingAct());
        Assert.assertEquals((long)alreadyLoaded, (long)listener1.getAlreadyLoaded());
        Document firstDoc = this.checkAct(act, first.getName());
        File duplicateFirst = this.createFile(source, first.getName(), "A");
        ++alreadyLoaded;
        LoggingLoaderListener listenerDup = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, null, true, false, (LoaderListener)listenerDup);
        Assert.assertEquals((long)0L, (long)listenerDup.getLoaded());
        Assert.assertEquals((long)1L, (long)listenerDup.getErrors());
        Assert.assertEquals((long)1L, (long)listenerDup.getProcessed());
        Assert.assertEquals((long)0L, (long)listenerDup.getMissingAct());
        Assert.assertEquals((long)alreadyLoaded, (long)listenerDup.getAlreadyLoaded());
        File second = this.createFile(act, source, null, "-A", "B");
        LoggingLoaderListener listener2 = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, null, true, false, (LoaderListener)listener2);
        Assert.assertEquals((long)1L, (long)listener2.getLoaded());
        Assert.assertEquals((long)1L, (long)listener2.getErrors());
        Assert.assertEquals((long)2L, (long)listener2.getProcessed());
        Assert.assertEquals((long)0L, (long)listener2.getMissingAct());
        Assert.assertEquals((long)alreadyLoaded, (long)listener2.getAlreadyLoaded());
        Document secondDoc = this.checkAct(act, second.getName());
        this.checkVersions(act, firstDoc);
        Assert.assertTrue((boolean)duplicateFirst.delete());
        File third = this.createFile(act, source, null, "-X", "A");
        Assert.assertTrue((boolean)third.setLastModified(second.lastModified() + 1000L));
        LoggingLoaderListener listener3 = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, null, true, false, (LoaderListener)listener3);
        Assert.assertEquals((long)1L, (long)listener3.getLoaded());
        Assert.assertEquals((long)0L, (long)listener3.getErrors());
        Assert.assertEquals((long)1L, (long)listener3.getProcessed());
        Assert.assertEquals((long)0L, (long)listener3.getMissingAct());
        Assert.assertEquals((long)0L, (long)listener3.getAlreadyLoaded());
        this.checkAct(act, third.getName());
        this.checkVersions(act, secondDoc);
    }

    @Test
    public void testLoadByType() throws Exception {
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        DocumentAct act1 = this.createPatientDocAct("file1.gif");
        DocumentAct act2 = this.createPatientDocAct("file2.pdf");
        DocumentAct act3 = this.createPatientDocAct("file3.html");
        DocumentAct act4 = this.createPatientDocAct("act.patientDocumentImage", "file4.png");
        DocumentAct act5 = this.createPatientDocAct("act.patientDocumentImage", "file5.gif");
        File act1File = this.createFile(act1, source, null, null, ".gif");
        File act2File = this.createFile(act2, source, "V", null, ".pdf");
        File act3File = this.createFile(act3, source, null, "-12345", null, ".html");
        File act4File = this.createFile(act4, source, null, null, ".png");
        File act5File = this.createFile(act5, source, null, null, ".gif");
        LoggingLoaderListener listener = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, "act.patientDocumentAttachment", target, null, false, false, (LoaderListener)listener);
        Assert.assertEquals((long)3L, (long)listener.getLoaded());
        Assert.assertEquals((long)2L, (long)listener.getErrors());
        Assert.assertEquals((long)5L, (long)listener.getProcessed());
        Assert.assertEquals((long)2L, (long)listener.getMissingAct());
        Assert.assertEquals((long)0L, (long)listener.getAlreadyLoaded());
        Set<File> files = this.getFiles(source);
        Assert.assertEquals((long)2L, (long)files.size());
        this.checkFiles(source, act4File, act5File);
        this.checkFiles(target, act1File, act2File, act3File);
        this.checkAct(act1, act1File.getName());
        this.checkAct(act2, act2File.getName());
        this.checkAct(act3, act3File.getName());
        this.checkNoDocument(act4);
        this.checkNoDocument(act5);
    }

    @Test
    public void testLoadDocumentTemplate() throws Exception {
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        String[] shortNames = new String[]{"act.documentTemplate"};
        try {
            DefaultLoadContext context = new DefaultLoadContext(new FileStrategy(target, null, false), (LoaderListener)new LoggingLoaderListener(DocumentLoader.log));
            new IdLoader(source, shortNames, this.getArchetypeService(), (DocumentFactory)new DefaultDocumentFactory(this.getArchetypeService()), this.transactionManager, true, true, (LoadContext)context);
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (Throwable exception) {
            Assert.assertEquals((Object)exception.getMessage(), (Object)"Argument 'shortNames' doesn't refer to any valid archetype for loading documents to: {act.documentTemplate}");
        }
        DocumentAct act = (DocumentAct)this.create("act.documentTemplate", DocumentAct.class);
        Entity template = (Entity)this.create("entity.documentTemplate", Entity.class);
        act.setName("foo");
        act.setDescription("bar");
        template.setName("ZTemplate");
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.addTarget("template", (IMObject)template);
        this.save((IMObject[])new AuditableIMObject[]{act, template});
        this.createFile(act, source, null, "-Z", "A");
        LoggingLoaderListener listener = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, null, true, false, (LoaderListener)listener);
        Assert.assertEquals((long)1L, (long)listener.getMissingAct());
        Assert.assertEquals((long)1L, (long)listener.getErrors());
    }

    @Test
    public void testLoadToCancelledAct() throws Exception {
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        File error = this.folder.newFolder("edocs");
        DocumentAct act1 = PatientTestHelper.createInvestigation((Party)TestHelper.createPatient(), (Entity)LaboratoryTestHelper.createInvestigationType());
        act1.setStatus("CANCELLED");
        this.save((IMObject)act1);
        File act1File = this.createFile(act1, source, null, null, ".gif");
        LoggingLoaderListener listener = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, error, false, false, (LoaderListener)listener);
        Assert.assertEquals((long)0L, (long)listener.getLoaded());
        Assert.assertEquals((long)1L, (long)listener.getErrors());
        Assert.assertEquals((long)1L, (long)listener.getProcessed());
        Assert.assertEquals((long)0L, (long)listener.getMissingAct());
        Assert.assertEquals((long)0L, (long)listener.getAlreadyLoaded());
        this.checkFiles(source, new File[0]);
        this.checkFiles(target, new File[0]);
        this.checkFiles(error, act1File);
        this.checkNoDocument(act1);
    }

    @Override
    protected File createSourceFile(DocumentAct act, File dir) throws IOException {
        return this.createFile(act, dir, null, null, ".gif");
    }

    @Override
    protected Loader createLoader(File source, String[] shortNames, IArchetypeService service, DocumentFactory factory, PlatformTransactionManager transactionManager, boolean overwrite, LoadContext context) {
        return new IdLoader(source, shortNames, service, factory, transactionManager, true, overwrite, context);
    }

    private DocumentAct getVersion(List<DocumentAct> versions, String fileName) {
        for (DocumentAct version : versions) {
            if (!fileName.equals(version.getFileName())) continue;
            return version;
        }
        return null;
    }
}

