/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.tools.doc;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.AuditableIMObject;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.etl.tools.doc.AbstractLoaderTest;
import org.openvpms.etl.tools.doc.DocumentLoader;
import org.openvpms.etl.tools.doc.DocumentLoaderException;

public class DocumentLoaderTestCase
extends AbstractLoaderTest {
    @Test
    public void testNoArgs() {
        String[] noArgs = new String[]{};
        this.checkConstructException(noArgs, DocumentLoaderException.ErrorCode.InvalidArguments);
    }

    @Test
    public void testByName() throws Exception {
        File source = this.folder.newFolder("source");
        File target = this.folder.newFolder("target");
        File file1 = new File(source, "file1-" + System.currentTimeMillis() + ".gif");
        File file2 = new File(source, "file2-" + System.currentTimeMillis() + ".gif");
        File file3 = new File(source, "file3-" + System.currentTimeMillis() + ".gif");
        File file4 = new File(source, "file4-" + System.currentTimeMillis() + ".gif");
        DocumentAct act1 = this.createPatientDocAct(file1.getName());
        DocumentAct act2 = this.createPatientDocAct(file2.getName());
        DocumentAct act3 = this.createPatientDocAct(file3.getName());
        DocumentAct act4 = this.createPatientDocAct(file4.getName());
        FileUtils.touch((File)file1);
        FileUtils.touch((File)file2);
        FileUtils.touch((File)file3);
        FileUtils.touch((File)file4);
        String[] args = new String[]{"--byname", "-s", source.getPath(), "-d", target.getPath()};
        DocumentLoader loader = new DocumentLoader(args, this.getArchetypeService(), this.transactionManager);
        loader.load();
        this.checkAct(act1);
        this.checkAct(act2);
        this.checkAct(act3);
        this.checkAct(act4);
        this.checkFiles(source, new File[0]);
        this.checkFiles(target, file1, file2, file3, file4);
    }

    @Test
    public void testByIdRecurse() throws Exception {
        File root = this.folder.newFolder("root");
        File sub1 = this.folder.newFolder(new String[]{"root", "sub1"});
        File sub2 = this.folder.newFolder(new String[]{"root", "sub2"});
        File target = this.folder.newFolder("target");
        DocumentAct act1 = this.createPatientDocAct();
        DocumentAct act2 = this.createPatientDocAct();
        DocumentAct act3 = this.createPatientDocAct();
        DocumentAct act4 = this.createPatientDocAct();
        File file1 = this.createFile(act1, sub1);
        File file2 = this.createFile(act2, sub1);
        File file3 = this.createFile(act3, sub2);
        File file4 = this.createFile(act4, sub2);
        String[] args = new String[]{"--byid", "-s", root.getPath(), "-d", target.getPath(), "--recurse"};
        DocumentLoader loader = new DocumentLoader(args, this.getArchetypeService(), this.transactionManager);
        loader.load();
        this.checkFiles(target, file1, file2, file3, file4);
        this.checkFiles(sub1, new File[0]);
        this.checkFiles(sub2, new File[0]);
    }

    @Test
    public void testByIdInvalidDirs() throws IOException {
        String[] args1 = new String[]{"--byid", "-s", "target/invalidsource"};
        this.checkConstructException(args1, DocumentLoaderException.ErrorCode.InvalidArguments);
        String[] args2 = new String[]{"--byid", "-d", "target/invalidtarget"};
        this.checkConstructException(args2, DocumentLoaderException.ErrorCode.InvalidArguments);
        File parent = this.folder.newFolder("parent");
        File target = this.folder.newFolder(new String[]{"parent", "target"});
        String[] args3 = new String[]{"--byid", "-s", parent.getPath(), "-d", target.getPath()};
        this.checkConstructException(args3, DocumentLoaderException.ErrorCode.TargetChildOfSource);
        String[] args4 = new String[]{"--byid", "-s", parent.getPath(), "-d", parent.getPath()};
        this.checkConstructException(args4, DocumentLoaderException.ErrorCode.SourceTargetSame);
        String[] args5 = new String[]{"--byid", "-s", parent.getPath(), "--err", target.getPath()};
        this.checkConstructException(args5, DocumentLoaderException.ErrorCode.ErrorChildOfSource);
        String[] args6 = new String[]{"--byid", "-s", parent.getPath(), "--err", parent.getPath()};
        this.checkConstructException(args6, DocumentLoaderException.ErrorCode.SourceErrorSame);
    }

    @Test
    public void testByIdCustomRegexp() throws Exception {
        File source = this.folder.newFolder("source");
        File target = this.folder.newFolder("target");
        DocumentAct act1 = this.createPatientDocAct();
        DocumentAct act2 = this.createPatientDocAct();
        DocumentAct act3 = this.createPatientDocAct();
        DocumentAct act4 = this.createPatientDocAct();
        File act1File = this.createFile(act1, source);
        File act2File = this.createFile(act2, source, "V");
        File act3File = this.createFile(act3, source, null, "-12345");
        File act4File = this.createFile(act4, source, "P", "-123456");
        String[] args = new String[]{"--byid", "-s", source.getPath(), "-d", target.getPath(), "--regexp", "(\\d+).gif"};
        DocumentLoader loader = new DocumentLoader(args, this.getArchetypeService(), this.transactionManager);
        loader.load();
        this.checkFiles(target, act1File);
        this.checkFiles(source, act2File, act3File, act4File);
    }

    @Test
    public void testByIdAndType() throws Exception {
        File source = this.folder.newFolder("source");
        File target = this.folder.newFolder("target");
        DocumentAct act1 = this.createPatientDocAct();
        DocumentAct act2 = this.createPatientDocAct();
        DocumentAct act3 = this.createPatientDocAct();
        DocumentAct act4 = this.createPatientDocAct();
        File file1 = this.createFile(act1, source);
        File file2 = this.createFile(act2, source);
        File file3 = this.createFile(act3, source);
        File file4 = this.createFile(act4, source);
        String[] args = new String[]{"--byid", "--type", "act.customerDocumentAttachment", "-s", source.getPath(), "-d", target.getPath()};
        DocumentLoader loader = new DocumentLoader(args, this.getArchetypeService(), this.transactionManager);
        loader.load();
        this.checkFiles(source, file1, file2, file3, file4);
        this.checkFiles(target, new File[0]);
        String[] args2 = new String[]{"--byid", "--type", "act.patientDocumentAttachment", "-s", source.getPath(), "-d", target.getPath()};
        DocumentLoader loader2 = new DocumentLoader(args2, this.getArchetypeService(), this.transactionManager);
        loader2.load();
        this.checkFiles(source, new File[0]);
        this.checkFiles(target, file1, file2, file3, file4);
    }

    @Test
    public void testDocumentTemplateActNotLoadedByDefault() throws Exception {
        File source = this.folder.newFolder("source");
        File target = this.folder.newFolder("target");
        File error = this.folder.newFolder("error");
        DocumentAct act = (DocumentAct)this.create("act.documentTemplate", DocumentAct.class);
        Entity template = (Entity)this.create("entity.documentTemplate", Entity.class);
        IMObjectBean actBean = this.getBean((IMObject)act);
        actBean.setValue("description", (Object)"A description");
        actBean.setTarget("template", (IMObject)template);
        template.setName("X Test template");
        this.save((IMObject[])new AuditableIMObject[]{act, template});
        File file = this.createFile(act, source);
        String[] args = new String[]{"--byid", "-s", source.getPath(), "-d", target.getPath(), "--err", error.getPath()};
        DocumentLoader loader = new DocumentLoader(args, this.getArchetypeService(), this.transactionManager);
        loader.load();
        this.checkFiles(source, new File[0]);
        this.checkFiles(target, new File[0]);
        this.checkFiles(error, file);
        try {
            String[] args2 = new String[]{"--byid", "--type", "act.documentTemplate", "-s", source.getPath(), "-d", target.getPath()};
            new DocumentLoader(args2, this.getArchetypeService(), this.transactionManager);
            Assert.fail((String)"Expected DocumentLoader constructor to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameDuplicates() throws Exception {
        File source = this.folder.newFolder("source");
        File target = this.folder.newFolder("target");
        DocumentAct act = this.createPatientDocAct();
        this.createFile(act, source);
        File file1 = this.createFile(act, target);
        File file2 = new File(target, act.getId() + "(1).gif");
        String[] args = new String[]{"--byid", "-s", source.getPath(), "-d", target.getPath(), "--rename", "--overwrite"};
        DocumentLoader loader = new DocumentLoader(args, this.getArchetypeService(), this.transactionManager);
        loader.load();
        this.checkFiles(source, new File[0]);
        this.checkFiles(target, file1, file2);
        this.createFile(act, source);
        File file3 = new File(target, act.getId() + "(2).gif");
        loader = new DocumentLoader(args, this.getArchetypeService(), this.transactionManager);
        loader.load();
        this.checkFiles(source, new File[0]);
        this.checkFiles(target, file1, file2, file3);
    }

    private void checkConstructException(String[] args, DocumentLoaderException.ErrorCode expected) {
        try {
            new DocumentLoader(args, this.getArchetypeService(), this.transactionManager);
            Assert.fail((String)"Expected a DocumentLoaderException");
        }
        catch (DocumentLoaderException exception) {
            Assert.assertEquals((Object)expected, (Object)exception.getErrorCode());
        }
    }
}

