/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.load;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.component.business.domain.im.common.Participation;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.ValidationException;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.lookup.LookupRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.etl.load.DefaultObjectHandler;
import org.openvpms.etl.load.ETLLog;
import org.openvpms.etl.load.ETLLogDAO;
import org.openvpms.etl.load.ETLLogDAOImpl;
import org.openvpms.etl.load.ETLRow;
import org.openvpms.etl.load.ErrorListener;
import org.openvpms.etl.load.Loader;
import org.openvpms.etl.load.Mapping;
import org.openvpms.etl.load.Mappings;
import org.openvpms.etl.load.ObjectHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class LoaderTestCase
extends ArchetypeServiceTest {
    @Autowired
    private SessionFactory sessionFactory;
    private ETLLogDAO dao;
    private TestLookupFactory lookupFactory;

    public LoaderTestCase() {
        super("archetypeService");
    }

    @Before
    public void setUp() {
        this.dao = new ETLLogDAOImpl(this.sessionFactory);
        this.lookupFactory = new TestLookupFactory((ArchetypeService)this.getArchetypeService());
    }

    @Test
    public void testObject() {
        String loaderName = "CUSTLOAD";
        this.dao.remove(loaderName, "ID1");
        Mappings mappings = new Mappings();
        mappings.setIdColumn("LEGACY_ID");
        Mapping firstNameMap = this.createMapping("FIRST_NAME", "<party.customerperson>firstName");
        Mapping lastNameMap = this.createMapping("LAST_NAME", "<party.customerperson>lastName");
        mappings.addMapping(firstNameMap);
        mappings.addMapping(lastNameMap);
        Loader loader = this.createLoader(loaderName, mappings);
        String legacyId = "ID1";
        ETLRow row = this.createCustomerRow(legacyId, "Foo", "Bar");
        List objects = loader.load(row);
        loader.close();
        Assert.assertEquals((long)1L, (long)objects.size());
        IMObject object = (IMObject)objects.get(0);
        IMObjectBean bean = this.getBean(object);
        Assert.assertEquals((Object)"Foo", (Object)bean.getString("firstName"));
        Assert.assertEquals((Object)"Bar", (Object)bean.getString("lastName"));
        List logs = this.dao.get(loaderName, legacyId, null);
        Assert.assertEquals((long)1L, (long)logs.size());
        this.checkLog(logs, loaderName, legacyId, "party.customerperson", -1);
    }

    @Test
    public void testCollection() {
        String loaderName = "CUSTLOAD";
        String legacyId = "ID1";
        this.dao.remove(loaderName, legacyId);
        Mappings mappings = new Mappings();
        mappings.setIdColumn("LEGACY_ID");
        Mapping addressMap = this.createMapping("ADDRESS", "<party.customerperson>contacts[0]<contact.location>address");
        Mapping suburbMap = this.createMapping("SUBURB", "<party.customerperson>contacts[0]<contact.location>suburb");
        Mapping phoneMap = this.createMapping("PHONE", "<party.customerperson>contacts[1]<contact.phoneNumber>telephoneNumber");
        mappings.addMapping(addressMap);
        mappings.addMapping(suburbMap);
        mappings.addMapping(phoneMap);
        Loader loader = this.createLoader(loaderName, mappings);
        ETLRow row = new ETLRow(legacyId);
        row.add("ADDRESS", (Object)"49 Foo St Bar");
        row.add("SUBURB", (Object)"Coburg");
        row.add("PHONE", (Object)"123456789");
        List objects = loader.load(row);
        loader.close();
        Assert.assertEquals((long)3L, (long)objects.size());
        IMObjectBean customer = this.getBean((IMObject)objects.get(0));
        IMObjectBean location = this.getBean((IMObject)objects.get(1));
        IMObjectBean phone = this.getBean((IMObject)objects.get(2));
        Assert.assertTrue((boolean)customer.isA(new String[]{"party.customerperson"}));
        Assert.assertTrue((boolean)location.isA(new String[]{"contact.location"}));
        Assert.assertTrue((boolean)phone.isA(new String[]{"contact.phoneNumber"}));
        List logs = this.dao.get(loaderName, legacyId, null);
        Assert.assertEquals((long)1L, (long)logs.size());
        this.checkLog(logs, loaderName, legacyId, "party.customerperson", -1);
    }

    @Test
    public void testCollectionHierarchy() {
        String loaderName = "CUSTLOAD";
        this.dao.remove(loaderName, "ID1");
        Mappings mappings = new Mappings();
        mappings.setIdColumn("LEGACY_ID");
        ((TestLookupBuilder)this.lookupFactory.newLookup("lookup.contactPurpose").code("MAILING")).build();
        Mapping firstNameMap = this.createMapping("FIRST_NAME", "<party.customerperson>firstName");
        Mapping lastNameMap = this.createMapping("LAST_NAME", "<party.customerperson>lastName");
        Mapping suburbMap = this.createMapping("ADDRESS", "<party.customerperson>contacts[0]<contact.location>purposes[1]");
        String ref = "<lookup.contactPurpose>code=MAILING";
        suburbMap.setValue(ref);
        mappings.addMapping(firstNameMap);
        mappings.addMapping(lastNameMap);
        mappings.addMapping(suburbMap);
        Loader loader = this.createLoader(loaderName, mappings);
        ETLRow row = this.createCustomerRow("ID1", "Foo", "Bar");
        row.add("ADDRESS", (Object)"49 Foo St Bar");
        List objects = loader.load(row);
        loader.close();
        Assert.assertEquals((long)2L, (long)objects.size());
        IMObjectBean customer = this.getBean((IMObject)objects.get(0));
        IMObjectBean location = this.getBean((IMObject)objects.get(1));
        Assert.assertTrue((boolean)customer.isA(new String[]{"party.customerperson"}));
        Assert.assertTrue((boolean)location.isA(new String[]{"contact.location"}));
    }

    @Test
    public void testValueExpansion() {
        Mappings mappings = new Mappings();
        mappings.setIdColumn("INVOICEID");
        Mapping mapping = this.createMapping("INVOICEID", "<act.customerAccountChargesInvoice>items[0]<actRelationship.customerAccountInvoiceItem>source");
        mapping.setValue("<act.customerAccountChargesInvoice>$value");
        mappings.addMapping(mapping);
        Loader loader = this.createLoader("ACTLOAD", mappings);
        ETLRow row = new ETLRow("INVOICE1");
        row.add("INVOICEID", (Object)"INVOICE1");
        List objects = loader.load(row);
        loader.close();
        Assert.assertEquals((long)2L, (long)objects.size());
        IMObjectBean act = this.getBean((IMObject)objects.get(0));
        IMObjectBean rel = this.getBean((IMObject)objects.get(1));
        Assert.assertTrue((boolean)act.isA(new String[]{"act.customerAccountChargesInvoice"}));
        Assert.assertTrue((boolean)rel.isA(new String[]{"actRelationship.customerAccountInvoiceItem"}));
        List items = act.getValues("items", ActRelationship.class);
        Assert.assertEquals((long)1L, (long)items.size());
        Assert.assertEquals((Object)rel.getObject(), items.get(0));
        Assert.assertEquals((Object)act.getObject().getObjectReference(), (Object)rel.getValue("source"));
    }

    @Test
    public void testExcludeNull() {
        Mappings mappings = new Mappings();
        mappings.setIdColumn("CUSTID");
        Mapping mapping = this.createMapping("TELEPHONE", "<party.customerperson>contacts[0]<contact.phoneNumber>telephoneNumber");
        mapping.setExcludeNull(true);
        mappings.addMapping(mapping);
        Loader loader = this.createLoader("CUSTLOAD", mappings);
        ETLRow row = new ETLRow("CUSTID");
        row.add("TELEPHONE", null);
        List objects = loader.load(row);
        loader.close();
        Assert.assertEquals((long)0L, (long)objects.size());
    }

    @Test
    public void testReferenceWildcards() {
        String loaderName = "INVLOAD";
        this.dao.remove("INVLOAD", "INV1");
        this.dao.remove("INVLOAD", "PROD1");
        Product product = (Product)this.create("product.medication", Product.class);
        product.setName("XLoaderTestCaseProduct" + System.currentTimeMillis());
        this.save((IMObject)product);
        this.addLog(loaderName, "PROD1", (IMObject)product);
        Mappings mappings = new Mappings();
        mappings.setIdColumn("INVOICEID");
        Mapping productMap = this.createMapping("PRODUCTID", "<act.customerAccountInvoiceItem>product[0]<participation.product>entity", "<product.*>$value");
        mappings.addMapping(productMap);
        Loader loader = this.createLoader(loaderName, mappings);
        ETLRow row = new ETLRow("INVOICEID");
        row.add("INVOICEID", (Object)"INV1");
        row.add("PRODUCTID", (Object)"PROD1");
        List objects = loader.load(row);
        loader.close();
        Assert.assertEquals((long)2L, (long)objects.size());
        IMObjectBean act = this.getBean((IMObject)objects.get(0));
        IMObjectBean participation = this.getBean((IMObject)objects.get(1));
        Assert.assertTrue((boolean)act.isA(new String[]{"act.customerAccountInvoiceItem"}));
        Assert.assertTrue((boolean)participation.isA(new String[]{"participation.product"}));
        List participations = act.getValues("product", Participation.class);
        Assert.assertEquals((long)1L, (long)participations.size());
        Assert.assertEquals(participations.get(0), (Object)participation.getObject());
        Assert.assertEquals((Object)product.getObjectReference(), (Object)participation.getValue("entity"));
    }

    @Test
    public void testLookups() {
        String loaderName = "PATIENTLOAD";
        this.dao.remove(loaderName, "patient1");
        this.dao.remove(loaderName, "patient2");
        Mappings mappings = new Mappings();
        mappings.setIdColumn("PATIENTID");
        Mapping nameMap = this.createMapping("NAME", "<party.patientpet>name");
        Mapping speciesMap = this.createMapping("SPECIES", "<party.patientpet>species");
        Mapping breedMap = this.createMapping("BREED", "<party.patientpet>breed");
        Mapping sexMap = this.createMapping("SEX", "<party.patientpet>sex");
        mappings.addMapping(nameMap);
        mappings.addMapping(speciesMap);
        mappings.addMapping(breedMap);
        mappings.addMapping(sexMap);
        String species1 = "S1" + System.currentTimeMillis();
        String species2 = "S2" + System.currentTimeMillis();
        String breed1 = "B1" + System.currentTimeMillis();
        String breed2 = "B2" + System.currentTimeMillis();
        Loader loader = this.createLoader(loaderName, mappings);
        ETLRow row1 = this.createPatientRow("patient1", "Fido", species1, breed1);
        List objects1 = loader.load(row1);
        Assert.assertEquals((long)1L, (long)objects1.size());
        this.checkSpeciesBreedLookups(species1, breed1);
        ETLRow row2 = this.createPatientRow("patient2", "Spot", species2, breed2);
        List objects2 = loader.load(row2);
        Assert.assertEquals((long)1L, (long)objects2.size());
        this.checkSpeciesBreedLookups(species2, breed2);
        loader.close();
        IMObject patient1 = this.get(((IMObject)objects1.get(0)).getObjectReference());
        IMObject patient2 = this.get(((IMObject)objects2.get(0)).getObjectReference());
        Assert.assertNotNull((Object)patient1);
        Assert.assertNotNull((Object)patient2);
        IMObjectBean bean1 = this.getBean(patient1);
        IMObjectBean bean2 = this.getBean(patient2);
        Assert.assertEquals((Object)"Fido", (Object)bean1.getString("name"));
        Assert.assertEquals((Object)"Spot", (Object)bean2.getString("name"));
        Assert.assertEquals((Object)species1, (Object)bean1.getString("species"));
        Assert.assertEquals((Object)species2, (Object)bean2.getString("species"));
        Assert.assertEquals((Object)breed1, (Object)bean1.getString("breed"));
        Assert.assertEquals((Object)breed2, (Object)bean2.getString("breed"));
        Assert.assertEquals((Object)("Male " + breed1), (Object)bean1.getString("description"));
        Assert.assertEquals((Object)("Male " + breed2), (Object)bean2.getString("description"));
    }

    @Test
    public void testLocalLookups() {
        Mappings mappings = new Mappings();
        mappings.setIdColumn("TEMPLATEID");
        Mapping nameMap = this.createMapping("NAME", "<product.medication>dispensingVerb");
        mappings.addMapping(nameMap);
        Mapping dispensingVerbMap = this.createMapping("DISPENSINGVERB", "<product.medication>dispensingVerb");
        mappings.addMapping(dispensingVerbMap);
        Loader loader = this.createLoader("TEMPLATELOAD", mappings);
        ETLRow row1 = this.createMedicationRow("document1", "med1", "GIVE");
        List objects = loader.load(row1);
        Assert.assertEquals((long)1L, (long)objects.size());
        Assert.assertEquals((Object)"GIVE", (Object)this.getBean((IMObject)objects.get(0)).getString("dispensingVerb"));
        ETLRow row2 = this.createMedicationRow("document2", "med2", "INJECT");
        objects = loader.load(row2);
        Assert.assertEquals((long)1L, (long)objects.size());
        Assert.assertEquals((Object)"INJECT", (Object)this.getBean((IMObject)objects.get(0)).getString("dispensingVerb"));
        loader.close();
    }

    @Test
    public void testMappingReference() {
        String loaderName = "PRICELOAD";
        this.dao.remove(loaderName, "PROD1");
        this.dao.remove(loaderName, "ID1");
        this.dao.remove(loaderName, "ID2");
        Product product = (Product)this.create("product.medication", Product.class);
        Assert.assertNotNull((Object)product);
        product.setName("XLoaderTestCaseProduct" + System.currentTimeMillis());
        this.save((IMObject)product);
        this.addLog(loaderName, "PROD1", (IMObject)product);
        Mappings mappings = new Mappings();
        mappings.setIdColumn("LEGACY_ID");
        Mapping priceMap = this.createMapping("PRICE", "$PRODID<product.medication>prices[1]<productPrice.unitPrice>price");
        mappings.addMapping(priceMap);
        Loader loader = this.createLoader(loaderName, mappings);
        String priceId1 = "ID1";
        String priceId2 = "ID2";
        BigDecimal price1 = new BigDecimal("1.5");
        BigDecimal price2 = new BigDecimal("0.95");
        ETLRow row1 = this.createPriceRow(priceId1, "PROD1", price1);
        ETLRow row2 = this.createPriceRow(priceId2, "PROD1", price2);
        List objects1 = loader.load(row1);
        List objects2 = loader.load(row2);
        loader.close();
        Assert.assertEquals((long)2L, (long)objects1.size());
        Assert.assertEquals((Object)product, objects1.get(0));
        Assert.assertEquals((long)2L, (long)objects2.size());
        Assert.assertEquals((Object)product, objects2.get(0));
        IMObjectBean price1Bean = this.getBean((IMObject)objects1.get(1));
        Assert.assertTrue((boolean)price1Bean.isA(new String[]{"productPrice.unitPrice"}));
        Assert.assertEquals((long)0L, (long)price1.compareTo(price1Bean.getBigDecimal("price")));
        IMObjectBean price2Bean = this.getBean((IMObject)objects2.get(1));
        Assert.assertTrue((boolean)price2Bean.isA(new String[]{"productPrice.unitPrice"}));
        Assert.assertEquals((long)0L, (long)price2.compareTo(price2Bean.getBigDecimal("price")));
        List logs = this.dao.get(loaderName, priceId1, null);
        Assert.assertEquals((long)1L, (long)logs.size());
        this.checkLog(logs, loaderName, priceId1, "product.medication", -1);
        logs = this.dao.get(loaderName, priceId2, null);
        Assert.assertEquals((long)1L, (long)logs.size());
        this.checkLog(logs, loaderName, priceId2, "product.medication", -1);
    }

    @Test
    public void testMappingWildcardLookup() {
        String loaderName = "APPTLOAD";
        this.dao.remove(loaderName, "CUST1");
        this.dao.remove(loaderName, "SCHEDULE1");
        this.dao.remove(loaderName, "APPT1");
        Lookup checkup = (Lookup)((TestLookupBuilder)this.lookupFactory.newLookup("lookup.visitReason").uniqueCode("CHECKUP")).build(false);
        Assert.assertNull((Object)this.getLookupService().getLookup("lookup.visitReason", checkup.getCode()));
        Party customer = TestHelper.createCustomer();
        Party location = TestHelper.createLocation();
        Party schedule = ScheduleTestHelper.createSchedule((Party)location);
        this.addLog(loaderName, "CUST1", (IMObject)customer);
        this.addLog(loaderName, "SCHEDULE1", (IMObject)schedule);
        Mappings mappings = new Mappings();
        mappings.addMapping(this.createMapping("CUSTOMER", "<act.customerAppointment>customer[0]<participation.customer>entity", "<party.customerperson>$value"));
        mappings.addMapping(this.createMapping("SCHEDULE", "<act.customerAppointment>schedule[0]<participation.schedule>entity", "<party.organisationSchedule>$value"));
        mappings.addMapping(this.createMapping("REASON", "<act.customerAppointment>reason", "<lookup.visitReason>$value"));
        Loader loader = this.createLoader(loaderName, mappings);
        ETLRow row = new ETLRow("APPT1");
        row.add("CUSTOMER", (Object)"CUST1");
        row.add("SCHEDULE", (Object)"SCHEDULE1");
        row.add("REASON", (Object)checkup.getCode());
        loader.load(row);
        Assert.assertNotNull((Object)this.getLookupService().getLookup("lookup.visitReason", checkup.getCode()));
    }

    @Test
    public void testErrorLogging() {
        String loaderName = "CUSTLOAD";
        String legacyId = "ID1";
        this.dao.remove(loaderName, "ID1");
        String expectedError = "Failed to validate Last Name of Customer: value is required";
        Mappings mappings = new Mappings();
        mappings.setIdColumn("LEGACY_ID");
        Mapping firstNameMap = this.createMapping("FIRST_NAME", "<party.customerperson>firstName");
        Mapping lastNameMap = this.createMapping("LAST_NAME", "<party.customerperson>lastName");
        mappings.addMapping(firstNameMap);
        mappings.addMapping(lastNameMap);
        IArchetypeService service = this.getArchetypeService();
        Loader loader = new Loader(loaderName, mappings, this.dao, service, this.getLookupService(), (ObjectHandler)new DefaultObjectHandler(loaderName, mappings, this.dao, service));
        ETLRow row = this.createCustomerRow("ID1", "Foo", null);
        Listener listener = new Listener("ID1", "Failed to validate Last Name of Customer: value is required", ValidationException.class);
        loader.setErrorListener((ErrorListener)listener);
        loader.load(row);
        loader.close();
        Assert.assertEquals((long)1L, (long)listener.getRowErrorCount());
        this.checkLogError(loaderName, "ID1", "Failed to validate Last Name of Customer: value is required");
    }

    @Test
    public void testPartialFailure() {
        String loaderName = "CUSTLOAD";
        String expectedError = "Failed to validate Last Name of Customer: value is required";
        IArchetypeService service = this.getArchetypeService();
        LookupService lookups = this.getLookupService();
        this.dao.remove("CUSTLOAD", "ID1");
        this.dao.remove("CUSTLOAD", "ID2");
        this.dao.remove("CUSTLOAD", "PATIENT1");
        Party patient = (Party)service.create("party.patientpet", Party.class);
        IMObjectBean bean = this.getBean((IMObject)patient);
        bean.setValue("species", (Object)"Foo");
        bean.setValue("breed", (Object)"Bar");
        patient.setName("XLoaderTestCasePatient" + System.currentTimeMillis());
        service.save((IMObject)patient);
        this.addLog("CUSTLOAD", "PATIENT1", (IMObject)patient);
        Mappings mappings = new Mappings();
        mappings.setBatchSize(50L);
        mappings.setIdColumn("CUSTOMERID");
        Mapping firstNameMap = this.createMapping("FIRST_NAME", "<party.customerperson>firstName");
        Mapping lastNameMap = this.createMapping("LAST_NAME", "<party.customerperson>lastName");
        Mapping sourceMap = this.createMapping("CUSTOMERID", "<entityRelationship.patientOwner>source", "<party.customerperson>$value");
        Mapping targetMap = this.createMapping("PATIENTID", "<entityRelationship.patientOwner>target", "<party.patientpet>$value");
        mappings.addMapping(firstNameMap);
        mappings.addMapping(lastNameMap);
        mappings.addMapping(sourceMap);
        mappings.addMapping(targetMap);
        Loader loader = new Loader("CUSTLOAD", mappings, this.dao, service, lookups, (ObjectHandler)new DefaultObjectHandler("CUSTLOAD", mappings, this.dao, service));
        ETLRow row1 = this.createCustomerRow("ID1", "Foo", "Bar");
        row1.add("PATIENTID", (Object)"PATIENT1");
        ETLRow row2 = this.createCustomerRow("ID2", "Pippi", null);
        row2.add("PATIENTID", (Object)"PATIENT1");
        ETLRow row3 = this.createCustomerRow("ID3", "Rin", "Bar");
        row3.add("PATIENTID", (Object)"PATIENT1");
        Listener listener = new Listener("ID2", "Failed to validate Last Name of Customer: value is required", ValidationException.class);
        loader.setErrorListener((ErrorListener)listener);
        loader.load(row1);
        loader.load(row2);
        loader.load(row3);
        loader.close();
        Assert.assertEquals((long)1L, (long)listener.getRowErrorCount());
        this.checkLogError("CUSTLOAD", "ID1", null, 2);
        this.checkLogError("CUSTLOAD", "ID2", "Failed to validate Last Name of Customer: value is required", 2);
        this.checkLogError("CUSTLOAD", "ID3", null, 2);
    }

    private void addLog(String loaderName, String legacyId, IMObject object) {
        ETLLog log = new ETLLog(loaderName, legacyId, object.getArchetype());
        log.setReference(object.getObjectReference());
        this.dao.save(log);
    }

    private void checkLog(List<ETLLog> logs, String loaderName, String legacyId, String archetype, int index) {
        boolean found = false;
        for (ETLLog log : logs) {
            if (!log.getLoader().equals(loaderName) || !log.getRowId().equals(legacyId) || !log.getArchetype().equals(archetype) || log.getIndex() != index) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
    }

    private void checkLogError(String loaderName, String legacyId, String message) {
        this.checkLogError(loaderName, legacyId, message, 1);
    }

    private void checkLogError(String loaderName, String legacyId, String message, int count) {
        List logs = this.dao.get(loaderName, legacyId, null);
        Assert.assertEquals((long)count, (long)logs.size());
        for (ETLLog log : logs) {
            Assert.assertEquals((Object)message, (Object)log.getErrors());
            if (message != null) {
                Assert.assertEquals((long)-1L, (long)log.getId());
                continue;
            }
            Assert.assertNotEquals((long)-1L, (long)log.getId());
        }
    }

    private void checkSpeciesBreedLookups(String speciesCode, String breedCode) {
        LookupService lookups = this.getLookupService();
        Lookup species = lookups.getLookup("lookup.species", speciesCode);
        Assert.assertNotNull((Object)species);
        Lookup breed = lookups.getLookup("lookup.breed", breedCode);
        Assert.assertNotNull((Object)breed);
        Set speciesRelationships = species.getLookupRelationships();
        Assert.assertEquals((long)1L, (long)speciesRelationships.size());
        LookupRelationship s = (LookupRelationship)speciesRelationships.iterator().next();
        Assert.assertEquals((Object)species.getObjectReference(), (Object)s.getSource());
        Assert.assertEquals((Object)breed.getObjectReference(), (Object)s.getTarget());
        Set breedRelationships = breed.getLookupRelationships();
        Assert.assertEquals((long)1L, (long)breedRelationships.size());
        LookupRelationship b = (LookupRelationship)breedRelationships.iterator().next();
        Assert.assertEquals((Object)species.getObjectReference(), (Object)b.getSource());
        Assert.assertEquals((Object)breed.getObjectReference(), (Object)b.getTarget());
    }

    private ETLRow createCustomerRow(String legacyId, String firstName, String lastName) {
        ETLRow row = new ETLRow(legacyId);
        row.add("CUSTOMERID", (Object)legacyId);
        row.add("FIRST_NAME", (Object)firstName);
        row.add("LAST_NAME", (Object)lastName);
        return row;
    }

    private ETLRow createPatientRow(String rowId, String name, String species, String breed) {
        ETLRow row = new ETLRow(rowId);
        row.add("PATIENTID", (Object)rowId);
        row.add("NAME", (Object)name);
        row.add("SPECIES", (Object)species);
        row.add("BREED", (Object)breed);
        row.add("SEX", (Object)"MALE");
        return row;
    }

    private ETLRow createPriceRow(String legacyId, String productId, BigDecimal price) {
        ETLRow row = new ETLRow(legacyId);
        row.add("PRICE", (Object)price);
        row.add("PRODID", (Object)productId);
        return row;
    }

    private ETLRow createMedicationRow(String rowId, String name, String dispensingVerb) {
        ETLRow row = new ETLRow(rowId);
        row.add("TEMPLATEID", (Object)rowId);
        row.add("NAME", (Object)name);
        row.add("DISPENSINGVERB", (Object)dispensingVerb);
        return row;
    }

    private Mapping createMapping(String source, String target) {
        return this.createMapping(source, target, null);
    }

    private Mapping createMapping(String source, String target, String value) {
        Mapping mapping = new Mapping();
        mapping.setSource(source);
        mapping.setTarget(target);
        mapping.setValue(value);
        return mapping;
    }

    private Loader createLoader(String loaderName, Mappings mappings) {
        IArchetypeService service = this.getArchetypeService();
        LookupService lookups = this.getLookupService();
        return new Loader(loaderName, mappings, this.dao, service, lookups, (ObjectHandler)new DefaultObjectHandler(loaderName, mappings, this.dao, service));
    }

    private static class Listener
    implements ErrorListener {
        private final String expectedRowId;
        private final String expectedMessage;
        private final Class<?> expectedException;
        private int count;

        public Listener(String rowId, String message, Class<?> exception) {
            this.expectedRowId = rowId;
            this.expectedMessage = message;
            this.expectedException = exception;
        }

        public int getRowErrorCount() {
            return this.count;
        }

        public void error(String rowId, String message, Throwable exception) {
            ++this.count;
            Assert.assertEquals((Object)this.expectedRowId, (Object)rowId);
            Assert.assertEquals((Object)this.expectedMessage, (Object)message);
            Assert.assertEquals(this.expectedException, exception.getClass());
        }

        public void error(String message, Throwable exception) {
            Assert.assertEquals((Object)this.expectedMessage, (Object)message);
            Assert.assertEquals(this.expectedException, exception.getClass());
        }
    }
}

