/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.load;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.etl.load.ETLLog;
import org.openvpms.etl.load.ETLLogDAO;

public class ETLLogDAOTestImpl
implements ETLLogDAO {
    private final Map<Long, ETLLog> logs = new HashMap<Long, ETLLog>();
    private long seed;

    public void save(ETLLog log) {
        if (log.getLogId() == 0L) {
            log.setLogId(++this.seed);
        }
        this.logs.put(log.getLogId(), log);
    }

    public void save(Iterable<ETLLog> logs) {
        for (ETLLog log : logs) {
            this.save(log);
        }
    }

    public ETLLog get(long logId) {
        return this.logs.get(logId);
    }

    public List<ETLLog> get(String loader, String rowId, String archetype) {
        ArrayList<ETLLog> result = new ArrayList<ETLLog>();
        for (ETLLog log : this.logs.values()) {
            if (loader != null && !log.getLoader().equals(loader) || archetype != null && !TypeHelper.matches((String)log.getArchetype(), (String)archetype) || !log.getRowId().equals(rowId)) continue;
            result.add(log);
        }
        return result;
    }

    public boolean processed(String loader, String rowId) {
        List<ETLLog> logs = this.get(loader, rowId, null);
        if (logs.isEmpty()) {
            return false;
        }
        for (ETLLog log : logs) {
            if (log.getErrors() == null) continue;
            return false;
        }
        return true;
    }

    public void remove(String loader, String rowId) {
        Iterator<ETLLog> iterator = this.logs.values().iterator();
        while (iterator.hasNext()) {
            ETLLog log = iterator.next();
            if (!log.getRowId().equals(rowId) || !log.getLoader().equals(loader)) continue;
            iterator.remove();
        }
    }
}

