/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.load;

public class Node {
    private final String field;
    private final String archetype;
    private final String name;
    private final int index;
    private Node parent;
    private Node child;

    public Node(String field, String archetype, String name, int index) {
        this.field = field;
        this.archetype = archetype;
        this.name = name;
        this.index = index;
    }

    public String getField() {
        return this.field;
    }

    public String getArchetype() {
        return this.archetype;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public String getObjectPath() {
        StringBuilder result = new StringBuilder();
        if (this.parent != null) {
            result.append(this.parent.getNodePath());
        }
        if (this.field != null) {
            result.append("$");
            result.append(this.field);
        }
        result.append("<");
        result.append(this.archetype);
        result.append(">");
        return result.toString();
    }

    public String getNodePath() {
        StringBuilder result = new StringBuilder(this.getObjectPath());
        result.append(this.name);
        if (this.index != -1) {
            result.append("[");
            result.append(this.index);
            result.append("]");
        }
        return result.toString();
    }

    public Node getChild() {
        return this.child;
    }

    public void setChild(Node child) {
        this.child = child;
        child.setParent(this);
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }
}

