/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.load;

import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.object.Reference;

public class ETLLog {
    private long logId;
    private long version;
    private String loader;
    private String rowId;
    private String archetype;
    private long id = -1L;
    private String linkId;
    private int index;
    private String errors;

    public ETLLog() {
        this(null, null, null);
    }

    public ETLLog(String loader, String rowId, String archetype) {
        this(loader, rowId, archetype, -1);
    }

    public ETLLog(String loader, String rowId, String archetype, int index) {
        this.rowId = rowId;
        this.archetype = archetype;
        this.loader = loader;
        this.index = index;
    }

    public long getLogId() {
        return this.logId;
    }

    public void setLogId(long logId) {
        this.logId = logId;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public String getLoader() {
        return this.loader;
    }

    public void setLoader(String loader) {
        this.loader = loader;
    }

    public String getRowId() {
        return this.rowId;
    }

    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    public String getArchetype() {
        return this.archetype;
    }

    public void setArchetype(String archetype) {
        this.archetype = archetype;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setReference(Reference reference) {
        if (reference != null) {
            this.id = reference.getId();
            this.linkId = reference.getLinkId();
        } else {
            this.id = -1L;
            this.linkId = null;
        }
    }

    public IMObjectReference getReference() {
        if (this.id == -1L && this.linkId == null) {
            return null;
        }
        return new IMObjectReference(new ArchetypeId(this.archetype), this.id, this.linkId);
    }

    public String getErrors() {
        return this.errors;
    }

    public void setErrors(String errors) {
        this.errors = errors;
    }

    protected long getId() {
        return this.id;
    }

    protected void setId(long id) {
        this.id = id;
    }

    protected String getLinkId() {
        return this.linkId;
    }

    protected void setLinkId(String linkId) {
        this.linkId = linkId;
    }
}

