/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.tools.doc;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentHelper;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.AuditableIMObject;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.etl.tools.doc.AbstractBasicLoaderTest;
import org.openvpms.etl.tools.doc.DefaultDocumentFactory;
import org.openvpms.etl.tools.doc.DefaultLoadContext;
import org.openvpms.etl.tools.doc.DefaultLoaderListener;
import org.openvpms.etl.tools.doc.DocumentFactory;
import org.openvpms.etl.tools.doc.DocumentLoader;
import org.openvpms.etl.tools.doc.FileLoaderListener;
import org.openvpms.etl.tools.doc.FileStrategy;
import org.openvpms.etl.tools.doc.LoadContext;
import org.openvpms.etl.tools.doc.Loader;
import org.openvpms.etl.tools.doc.LoaderListener;
import org.openvpms.etl.tools.doc.LoggingLoaderListener;
import org.openvpms.etl.tools.doc.NameLoader;
import org.springframework.transaction.PlatformTransactionManager;

public class NameLoaderTestCase
extends AbstractBasicLoaderTest {
    @Test
    public void testLoad() throws IOException {
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        DocumentAct act1 = this.createPatientDocAct("file1-" + System.nanoTime() + ".gif");
        DocumentAct act2 = this.createPatientDocAct("file2-" + System.nanoTime() + ".pdf");
        DocumentAct act3 = this.createPatientDocAct("file3-" + System.nanoTime() + ".html");
        DocumentAct act4 = this.createPatientDocAct("file4-" + System.nanoTime() + ".png");
        DocumentAct act5 = this.createPatientDocAct("file5-" + System.nanoTime() + ".htm");
        DocumentAct act6 = this.createPatientDocAct("file6-" + System.nanoTime() + ".txt");
        DocumentAct act7 = this.createPatientDocAct("file7-" + System.nanoTime() + ".doc");
        DocumentAct act8 = this.createPatientDocAct("file8-" + System.nanoTime() + ".odt");
        File act1File = this.createFile(source, act1.getFileName(), null);
        File act2File = this.createFile(source, act2.getFileName(), null);
        File act3File = this.createFile(source, act3.getFileName(), null);
        File act4File = this.createFile(source, act4.getFileName(), null);
        File act5File = this.createFile(source, act5.getFileName(), null);
        File act6File = this.createFile(source, act6.getFileName(), null);
        File act7File = this.createFile(source, act7.getFileName(), null);
        File act8File = this.createFile(source, act8.getFileName(), null);
        LoggingLoaderListener listener = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, null, false, false, (LoaderListener)listener);
        this.checkFiles(target, act1File, act2File, act3File, act4File, act5File, act6File, act7File, act8File);
        Assert.assertEquals((long)8L, (long)listener.getLoaded());
        Assert.assertEquals((long)8L, (long)listener.getProcessed());
        Assert.assertEquals((long)0L, (long)listener.getErrors());
        this.checkAct(act1);
        this.checkAct(act2);
        this.checkAct(act3);
        this.checkAct(act4);
        this.checkAct(act5);
        this.checkAct(act6);
        this.checkAct(act7);
        this.checkAct(act8);
    }

    @Test
    public void testMissingAct() throws Exception {
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        File file = new File(source, System.nanoTime() + ".gif");
        FileUtils.touch((File)file);
        LoggingLoaderListener listener = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, null, false, false, (LoaderListener)listener);
        Assert.assertEquals((long)0L, (long)listener.getLoaded());
        Assert.assertEquals((long)1L, (long)listener.getErrors());
        Assert.assertEquals((long)1L, (long)listener.getProcessed());
        Assert.assertEquals((long)1L, (long)listener.getMissingAct());
        Assert.assertEquals((long)0L, (long)listener.getAlreadyLoaded());
        this.checkFiles(source, file);
        this.checkFiles(target, new File[0]);
    }

    @Test
    public void testSkipProcessed() throws Exception {
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        DocumentAct preLoaded = this.createPatientDocAct();
        File preloadedFile = this.createFile(preLoaded, source, null);
        Document doc = DocumentHelper.create((File)preloadedFile, (String)"image/gif", (DocumentHandlers)new DocumentHandlers((ArchetypeService)this.getArchetypeService()));
        preLoaded.setDocument((Reference)doc.getObjectReference());
        preLoaded.setFileName(doc.getName());
        this.save((IMObject[])new AuditableIMObject[]{doc, preLoaded});
        LoggingLoaderListener listener = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, null, false, false, (LoaderListener)listener);
        Assert.assertEquals((long)0L, (long)listener.getLoaded());
        Assert.assertEquals((long)1L, (long)listener.getErrors());
        Assert.assertEquals((long)1L, (long)listener.getProcessed());
        Assert.assertEquals((long)1L, (long)listener.getMissingAct());
        Assert.assertEquals((long)0L, (long)listener.getAlreadyLoaded());
        this.checkFiles(source, preloadedFile);
        this.checkFiles(target, new File[0]);
    }

    @Test
    public void testLoadDocumentTemplate() throws Exception {
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        FileLoaderListener listener = new FileLoaderListener((LoaderListener)new DefaultLoaderListener());
        DefaultLoadContext context = new DefaultLoadContext(new FileStrategy(target, null, false), (LoaderListener)listener);
        try {
            new NameLoader(source, new String[]{"act.documentTemplate"}, this.getArchetypeService(), (DocumentFactory)new DefaultDocumentFactory(this.getArchetypeService()), this.transactionManager, false, false, (LoadContext)context);
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (Throwable exception) {
            Assert.assertEquals((Object)exception.getMessage(), (Object)"Argument 'shortNames' doesn't refer to any valid archetype for loading documents to: {act.documentTemplate}");
        }
        DocumentAct act = (DocumentAct)this.create("act.documentTemplate", DocumentAct.class);
        File file = this.createFile(act, source, null, "-Z", "A");
        Entity template = (Entity)this.create("entity.documentTemplate", Entity.class);
        act.setName("foo");
        act.setDescription("bar");
        template.setName("ZTemplate");
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setValue("fileName", (Object)file.getName());
        bean.setTarget("template", (IMObject)template);
        this.save((IMObject[])new AuditableIMObject[]{act, template});
        this.load(source, target, null, true, false, (LoaderListener)listener);
        Assert.assertEquals((long)0L, (long)listener.getLoaded());
        Assert.assertEquals((long)0L, (long)listener.getAlreadyLoaded());
        Assert.assertEquals((long)1L, (long)listener.getMissingAct());
        Assert.assertEquals((long)1L, (long)listener.getErrors());
    }

    @Test
    public void testDuplicates() throws Exception {
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        File first = this.createFile(source, System.nanoTime() + ".gif", "A");
        DocumentAct act = this.createPatientDocAct(first.getName());
        LoggingLoaderListener listener1 = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, null, true, false, (LoaderListener)listener1);
        Assert.assertEquals((long)1L, (long)listener1.getLoaded());
        Assert.assertEquals((long)0L, (long)listener1.getErrors());
        Assert.assertEquals((long)1L, (long)listener1.getProcessed());
        Assert.assertEquals((long)0L, (long)listener1.getMissingAct());
        Assert.assertEquals((long)0L, (long)listener1.getAlreadyLoaded());
        Assert.assertTrue((boolean)new File(target, first.getName()).delete());
        Document firstDoc = this.checkAct(act, first.getName());
        LoggingLoaderListener listenerDup = new LoggingLoaderListener(DocumentLoader.log);
        this.createFile(source, first.getName(), "A");
        this.load(source, target, null, true, false, (LoaderListener)listenerDup);
        Assert.assertEquals((long)0L, (long)listenerDup.getLoaded());
        Assert.assertEquals((long)1L, (long)listenerDup.getErrors());
        Assert.assertEquals((long)1L, (long)listenerDup.getProcessed());
        Assert.assertEquals((long)0L, (long)listenerDup.getMissingAct());
        Assert.assertEquals((long)1L, (long)listenerDup.getAlreadyLoaded());
        File second = this.createFile(source, first.getName(), "B");
        LoggingLoaderListener listener2 = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, null, true, false, (LoaderListener)listener2);
        Assert.assertEquals((long)1L, (long)listener2.getLoaded());
        Assert.assertEquals((long)0L, (long)listener2.getErrors());
        Assert.assertEquals((long)1L, (long)listener2.getProcessed());
        Assert.assertEquals((long)0L, (long)listener2.getMissingAct());
        Assert.assertEquals((long)0L, (long)listener2.getAlreadyLoaded());
        Document secondDoc = this.checkAct(act, second.getName());
        this.checkVersions(act, firstDoc);
        File third = this.createFile(source, first.getName(), "A");
        Assert.assertTrue((boolean)third.setLastModified(second.lastModified() + 1000L));
        LoggingLoaderListener listener3 = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, null, true, false, (LoaderListener)listener3);
        Assert.assertEquals((long)0L, (long)listener3.getLoaded());
        Assert.assertEquals((long)1L, (long)listener3.getErrors());
        Assert.assertEquals((long)1L, (long)listener3.getProcessed());
        Assert.assertEquals((long)0L, (long)listener3.getMissingAct());
        Assert.assertEquals((long)1L, (long)listener3.getAlreadyLoaded());
        act = (DocumentAct)this.get((IMObject)act);
        this.checkAct(act, second.getName());
        Assert.assertEquals((Object)act.getDocument(), (Object)secondDoc.getObjectReference());
        this.checkVersions(act, firstDoc);
    }

    @Test
    public void testActsWithDuplicateFileNames() throws IOException {
        File source = this.folder.newFolder("sdocs");
        File target = this.folder.newFolder("tdocs");
        File file = this.createFile(source, System.nanoTime() + ".gif", "A");
        this.createPatientDocAct(file.getName());
        this.createPatientDocAct(file.getName());
        LoggingLoaderListener listener1 = new LoggingLoaderListener(DocumentLoader.log);
        this.load(source, target, null, true, false, (LoaderListener)listener1);
        Assert.assertEquals((long)0L, (long)listener1.getLoaded());
        Assert.assertEquals((long)1L, (long)listener1.getErrors());
        Assert.assertEquals((long)1L, (long)listener1.getProcessed());
        Assert.assertEquals((long)0L, (long)listener1.getMissingAct());
        Assert.assertEquals((long)0L, (long)listener1.getAlreadyLoaded());
    }

    @Override
    protected File createSourceFile(DocumentAct act, File dir) throws IOException {
        File file = this.createFile(dir, "file1-" + System.nanoTime() + ".gif", "");
        act.setFileName(file.getName());
        this.save((IMObject)act);
        return file;
    }

    @Override
    protected Loader createLoader(File source, String[] shortNames, IArchetypeService service, DocumentFactory factory, PlatformTransactionManager transactionManager, boolean overwrite, LoadContext context) {
        return new NameLoader(source, shortNames, service, factory, transactionManager, false, overwrite, context);
    }
}

