/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.tools.doc;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class FileStrategy {
    private final File target;
    private final File error;
    private final boolean renameDuplicates;

    public FileStrategy(File target, File error, boolean renameDuplicates) {
        this.target = target;
        this.error = error;
        this.renameDuplicates = renameDuplicates;
    }

    public File getTarget() {
        return this.target;
    }

    public File getError() {
        return this.error;
    }

    public boolean getRenameDuplicates() {
        return this.renameDuplicates;
    }

    public File loaded(File file) throws IOException {
        File result = this.target != null ? this.move(file, this.target) : file;
        return result;
    }

    public File error(File file) throws IOException {
        File result = this.error != null ? this.move(file, this.error) : file;
        return result;
    }

    private File move(File file, File dir) throws IOException {
        File to = new File(dir, file.getName());
        if (to.exists()) {
            if (this.renameDuplicates) {
                to = this.getUniqueFile(to);
            } else {
                throw new IOException("Cannot copy " + file.getPath() + " to " + dir.getPath() + ": file exists");
            }
        }
        Files.move(file.toPath(), to.toPath(), new CopyOption[0]);
        return to;
    }

    private File getUniqueFile(File file) {
        File parent = file.getParentFile();
        String baseName = FilenameUtils.getBaseName((String)file.getName());
        String ext = FilenameUtils.getExtension((String)file.getName());
        int id = 1;
        while ((file = new File(parent, this.getName(baseName, id, ext))).exists()) {
            ++id;
        }
        return file;
    }

    private String getName(String baseName, int index, String ext) {
        String result = baseName + "(" + index + ")";
        return !StringUtils.isEmpty((CharSequence)ext) ? result + "." + ext : result;
    }
}

